/*
 * Decompiled with CFR 0.152.
 */
package org.kie.drl.engine.compilation.service;

import java.util.Collections;
import java.util.List;
import org.kie.drl.engine.compilation.model.DrlCompilationContext;
import org.kie.drl.engine.compilation.model.DrlFileSetResource;
import org.kie.drl.engine.compilation.utils.DrlCompilerHelper;
import org.kie.efesto.compilationmanager.api.exceptions.KieCompilerServiceException;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationContext;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationOutput;
import org.kie.efesto.compilationmanager.api.model.EfestoResource;
import org.kie.efesto.compilationmanager.api.service.KieCompilerService;

public class KieCompilerServiceDrl
implements KieCompilerService {
    public <T extends EfestoResource> boolean canManageResource(T toProcess) {
        return toProcess instanceof DrlFileSetResource;
    }

    public <T extends EfestoResource, E extends EfestoCompilationOutput> List<E> processResource(T toProcess, EfestoCompilationContext context) {
        if (!this.canManageResource(toProcess)) {
            throw new KieCompilerServiceException(String.format("%s can not process %s", this.getClass().getName(), toProcess.getClass().getName()));
        }
        if (!(context instanceof DrlCompilationContext)) {
            throw new KieCompilerServiceException("context has to be DrlCompilationContext");
        }
        return Collections.singletonList(DrlCompilerHelper.drlToPackageDescrs((DrlFileSetResource)toProcess, (DrlCompilationContext)context));
    }
}

