/*
 * Decompiled with CFR 0.152.
 */
package org.kie.drl.engine.compilation.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.drools.compiler.builder.impl.BuildResultCollector;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.resources.DrlResourceHandler;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.DroolsParserException;
import org.drools.model.codegen.project.KogitoPackageSources;
import org.drools.model.codegen.project.RuleCodegenError;
import org.drools.model.codegen.tool.ExplicitCanonicalModelCompiler;
import org.kie.api.io.Resource;
import org.kie.drl.engine.compilation.model.DecisionTableFileSetResource;
import org.kie.drl.engine.compilation.model.DrlCompilationContext;
import org.kie.drl.engine.compilation.model.DrlFileSetResource;
import org.kie.drl.engine.compilation.model.DrlPackageDescrSetResource;
import org.kie.drl.engine.compilation.model.ExecutableModelClassesContainer;
import org.kie.efesto.common.api.model.FRI;
import org.kie.efesto.compilationmanager.api.exceptions.KieCompilerServiceException;
import org.kie.efesto.compilationmanager.api.model.EfestoSetResource;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.ResultSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrlCompilerHelper {
    private static final Logger logger = LoggerFactory.getLogger(DrlCompilerHelper.class);

    private DrlCompilerHelper() {
    }

    public static ExecutableModelClassesContainer dTableToDrl(DecisionTableFileSetResource resources, DrlCompilationContext context) {
        throw new KieCompilerServiceException("Not implemented, yet");
    }

    public static DrlPackageDescrSetResource drlToPackageDescrs(DrlFileSetResource resources, DrlCompilationContext context) {
        KnowledgeBuilderConfigurationImpl conf = (KnowledgeBuilderConfigurationImpl)context.newKnowledgeBuilderConfiguration();
        Set<PackageDescr> packageDescrSet = DrlCompilerHelper.buildCompositePackageDescrs(resources, conf).stream().collect(Collectors.toSet());
        return new DrlPackageDescrSetResource(packageDescrSet, resources.getBasePath());
    }

    public static ExecutableModelClassesContainer pkgDescrToExecModel(EfestoSetResource<PackageDescr> resources, DrlCompilationContext context) {
        return DrlCompilerHelper.pkgDescrToExecModel(DrlCompilerHelper.toCompositePackageDescrs(resources.getContent()), resources.getBasePath(), new KnowledgeBuilderConfigurationImpl(), context);
    }

    public static ExecutableModelClassesContainer drlToExecutableModel(DrlFileSetResource resources, DrlCompilationContext context) {
        KnowledgeBuilderConfigurationImpl conf = (KnowledgeBuilderConfigurationImpl)context.newKnowledgeBuilderConfiguration();
        return DrlCompilerHelper.pkgDescrToExecModel(DrlCompilerHelper.buildCompositePackageDescrs(resources, conf), resources.getBasePath(), conf, context);
    }

    public static ExecutableModelClassesContainer pkgDescrToExecModel(Collection<CompositePackageDescr> packages, String basePath, KnowledgeBuilderConfigurationImpl knowledgeBuilderConfiguration, DrlCompilationContext context) {
        ExplicitCanonicalModelCompiler compiler = ExplicitCanonicalModelCompiler.of(packages, (KnowledgeBuilderConfigurationImpl)knowledgeBuilderConfiguration, KogitoPackageSources::dumpSources);
        compiler.process();
        BuildResultCollector buildResults = compiler.getBuildResults();
        if (buildResults.hasErrors()) {
            for (KnowledgeBuilderResult e : buildResults.getResults(new ResultSeverity[0])) {
                logger.error(e.getMessage(), (Object)e);
            }
            throw new RuleCodegenError(buildResults.getAllResults());
        }
        Collection packageSources = compiler.getPackageSources();
        ArrayList modelFiles = new ArrayList();
        ArrayList<String> generatedRulesModels = new ArrayList<String>();
        for (KogitoPackageSources pkgSources : packageSources) {
            pkgSources.collectGeneratedFiles(modelFiles);
            generatedRulesModels.add(pkgSources.getPackageName() + "." + pkgSources.getRulesFileName());
        }
        Map<String, String> sourceCode = modelFiles.stream().collect(Collectors.toMap(generatedFile -> generatedFile.getPath().replace(".java", "").replace(File.separatorChar, '.'), generatedFile -> new String(generatedFile.getData(), StandardCharsets.UTF_8)));
        Map compiledClasses = context.compileClasses(sourceCode);
        return new ExecutableModelClassesContainer(new FRI(basePath, "drl"), generatedRulesModels, compiledClasses);
    }

    private static Collection<CompositePackageDescr> buildCompositePackageDescrs(DrlFileSetResource resources, KnowledgeBuilderConfigurationImpl conf) {
        DrlResourceHandler drlResourceHandler = new DrlResourceHandler(conf);
        return DrlCompilerHelper.toCompositePackageDescrs(resources.getFileSystemResource().stream().map(r -> DrlCompilerHelper.resourceToPackageDescr(drlResourceHandler, (Resource)r)).collect(Collectors.toList()));
    }

    private static Collection<CompositePackageDescr> toCompositePackageDescrs(Iterable<PackageDescr> packageDescrs) {
        HashMap<String, CompositePackageDescr> packages = new HashMap<String, CompositePackageDescr>();
        for (PackageDescr packageDescr : packageDescrs) {
            DrlCompilerHelper.addPackageDescr(packageDescr, packageDescr.getResource(), packages);
        }
        return packages.values();
    }

    private static void addPackageDescr(PackageDescr packageDescr, Resource resource, Map<String, CompositePackageDescr> packages) {
        packages.computeIfAbsent(packageDescr.getNamespace(), CompositePackageDescr::new).addPackageDescr(resource, packageDescr);
    }

    private static PackageDescr resourceToPackageDescr(DrlResourceHandler drlResourceHandler, Resource resource) {
        try {
            return drlResourceHandler.process(resource);
        }
        catch (IOException | DroolsParserException e) {
            throw new KieCompilerServiceException(e);
        }
    }
}

