/*
 * Decompiled with CFR 0.152.
 */
package org.kie.drl.engine.compilation.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.resources.DrlResourceHandler;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.DroolsParserException;
import org.drools.io.FileSystemResource;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.drl.engine.compilation.model.DrlCompilationContext;
import org.kie.drl.engine.compilation.model.DrlFileSetResource;
import org.kie.drl.engine.compilation.model.DrlPackageDescrSetResource;
import org.kie.drl.engine.compilation.model.ExecutableModelClassesContainer;
import org.kie.drl.engine.compilation.utils.DrlCompilerHelper;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationOutput;
import org.kie.efesto.compilationmanager.api.model.EfestoSetResource;

class DrlCompilerHelperTest {
    private static DrlCompilationContext context;
    private static Set<File> drlFiles;
    private static Set<PackageDescr> packageDescrs;

    DrlCompilerHelperTest() {
    }

    @BeforeAll
    static void setUp() throws IOException, DroolsParserException {
        context = DrlCompilationContext.buildWithParentClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader());
        drlFiles = Files.walk(Paths.get("src/test/resources", new String[0]), new FileVisitOption[0]).map(Path::toFile).filter(File::isFile).collect(Collectors.toSet());
        KnowledgeBuilderConfigurationImpl knowledgeBuilderConfiguration = new KnowledgeBuilderConfigurationImpl();
        DrlResourceHandler drlResourceHandler = new DrlResourceHandler(knowledgeBuilderConfiguration);
        packageDescrs = new HashSet<PackageDescr>();
        for (File drlFile : drlFiles) {
            FileSystemResource fileSystemResource = new FileSystemResource(drlFile);
            PackageDescr process = drlResourceHandler.process((Resource)fileSystemResource);
            packageDescrs.add(process);
        }
    }

    @Test
    void getDrlCallableClassesContainerFromPackageDescrResource() {
        String basePath = UUID.randomUUID().toString();
        DrlPackageDescrSetResource toProcess = new DrlPackageDescrSetResource(packageDescrs, basePath);
        ExecutableModelClassesContainer retrieved = DrlCompilerHelper.pkgDescrToExecModel((EfestoSetResource)toProcess, (DrlCompilationContext)context);
        this.commonVerifyEfestoCompilationOutput((EfestoCompilationOutput)retrieved, basePath);
    }

    @Test
    void getDrlCallableClassesContainerFromFileResource() {
        String basePath = UUID.randomUUID().toString();
        DrlFileSetResource toProcess = new DrlFileSetResource(drlFiles, basePath);
        ExecutableModelClassesContainer retrieved = DrlCompilerHelper.drlToExecutableModel((DrlFileSetResource)toProcess, (DrlCompilationContext)context);
        this.commonVerifyEfestoCompilationOutput((EfestoCompilationOutput)retrieved, basePath);
    }

    private void commonVerifyEfestoCompilationOutput(EfestoCompilationOutput toVerify, String baseBath) {
        ((ObjectAssert)Assertions.assertThat((Object)toVerify).isNotNull()).isInstanceOf(ExecutableModelClassesContainer.class);
        ExecutableModelClassesContainer retrieved = (ExecutableModelClassesContainer)toVerify;
        Assertions.assertThat((String)retrieved.getModelLocalUriId().model()).isEqualTo("drl");
        Assertions.assertThat((String)retrieved.getModelLocalUriId().basePath()).isEqualTo("/" + baseBath);
        Assertions.assertThat((List)retrieved.getFullClassNames()).hasSize(3);
        Assertions.assertThat((Map)retrieved.getCompiledClassesMap()).hasSize(45);
    }
}

