/*
 * Decompiled with CFR 0.152.
 */
package org.kie.drl.engine.testingmodule;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.api.runtime.KieSession;
import org.kie.drl.engine.compilation.model.DrlCompilationContext;
import org.kie.drl.engine.compilation.model.DrlFileSetResource;
import org.kie.drl.engine.runtime.kiesession.local.model.EfestoInputDrlKieSessionLocal;
import org.kie.drl.engine.runtime.kiesession.local.model.EfestoOutputDrlKieSessionLocal;
import org.kie.drl.engine.testingmodule.utils.DrlTestUtils;
import org.kie.efesto.common.api.model.FRI;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationContext;
import org.kie.efesto.compilationmanager.api.model.EfestoResource;
import org.kie.efesto.compilationmanager.api.service.CompilationManager;
import org.kie.efesto.compilationmanager.core.service.CompilationManagerImpl;
import org.kie.efesto.runtimemanager.api.model.EfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoOutput;
import org.kie.efesto.runtimemanager.api.model.EfestoRuntimeContext;
import org.kie.efesto.runtimemanager.api.service.RuntimeManager;
import org.kie.efesto.runtimemanager.core.service.RuntimeManagerImpl;

class OnTheFlyDrlTest {
    private static RuntimeManager runtimeManager;
    private static CompilationManager compilationManager;

    OnTheFlyDrlTest() {
    }

    @BeforeAll
    static void setUp() {
        DrlTestUtils.refreshDrlIndexFile();
        runtimeManager = new RuntimeManagerImpl();
        compilationManager = new CompilationManagerImpl();
    }

    @Test
    void evaluateWithKieSessionLocalCompilationOnTheFly() throws IOException {
        String onTheFlyPath = "OnTheFlyPath";
        Set<File> files = DrlTestUtils.collectDrlFiles("src/test/resources/org/drools/model/project/codegen");
        DrlFileSetResource toProcess = new DrlFileSetResource(files, onTheFlyPath);
        DrlCompilationContext compilationContext = DrlCompilationContext.buildWithParentClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader());
        Collection indexFiles = compilationManager.processResource((EfestoCompilationContext)compilationContext, new EfestoResource[]{toProcess});
        EfestoRuntimeContext runtimeContext = EfestoRuntimeContext.buildWithParentClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader());
        EfestoInputDrlKieSessionLocal toEvaluate = new EfestoInputDrlKieSessionLocal(new FRI(onTheFlyPath, "drl"), "");
        Collection output = runtimeManager.evaluateInput(runtimeContext, new EfestoInput[]{toEvaluate});
        ((IterableAssert)Assertions.assertThat((Iterable)output).isNotNull()).hasSize(1);
        EfestoOutput retrievedRaw = (EfestoOutput)output.iterator().next();
        Assertions.assertThat((Object)retrievedRaw).isInstanceOf(EfestoOutputDrlKieSessionLocal.class);
        EfestoOutputDrlKieSessionLocal retrieved = (EfestoOutputDrlKieSessionLocal)retrievedRaw;
        ((ObjectAssert)Assertions.assertThat((Object)((KieSession)retrieved.getOutputData())).isNotNull()).isInstanceOf(KieSession.class);
        KieSession session = (KieSession)retrieved.getOutputData();
        session.insert((Object)"test");
        Assertions.assertThat((int)session.fireAllRules()).isEqualTo(3);
    }
}

