/*
 * Decompiled with CFR 0.152.
 */
package org.kie.drl.engine.testingmodule.compilation;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.resources.DrlResourceHandler;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.DroolsParserException;
import org.drools.io.FileSystemResource;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.drl.engine.compilation.model.DrlCompilationContext;
import org.kie.drl.engine.compilation.model.DrlFileSetResource;
import org.kie.drl.engine.compilation.model.DrlPackageDescrSetResource;
import org.kie.drl.engine.testingmodule.utils.DrlTestUtils;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationContext;
import org.kie.efesto.compilationmanager.api.model.EfestoResource;
import org.kie.efesto.compilationmanager.api.service.CompilationManager;
import org.kie.efesto.compilationmanager.core.service.CompilationManagerImpl;

class CompileDrlTest {
    private static CompilationManager compilationManager;
    private static DrlCompilationContext context;
    private static Set<File> drlFiles;
    private static Set<PackageDescr> packageDescrs;

    CompileDrlTest() {
    }

    @BeforeAll
    static void setUp() throws IOException, DroolsParserException {
        DrlTestUtils.refreshDrlIndexFile();
        compilationManager = new CompilationManagerImpl();
        context = DrlCompilationContext.buildWithParentClassLoader((ClassLoader)CompilationManager.class.getClassLoader());
        drlFiles = DrlTestUtils.collectDrlFiles("src/test/resources/org/drools/model/project/codegen");
        KnowledgeBuilderConfigurationImpl knowledgeBuilderConfiguration = new KnowledgeBuilderConfigurationImpl();
        DrlResourceHandler drlResourceHandler = new DrlResourceHandler(knowledgeBuilderConfiguration);
        packageDescrs = new HashSet<PackageDescr>();
        for (File drlFile : drlFiles) {
            FileSystemResource fileSystemResource = new FileSystemResource(drlFile);
            PackageDescr process = drlResourceHandler.process((Resource)fileSystemResource);
            packageDescrs.add(process);
        }
    }

    @Test
    void compileDrlFromFile() {
        String basePath = UUID.randomUUID().toString();
        DrlFileSetResource toProcess = new DrlFileSetResource(drlFiles, basePath);
        Collection retrieved = compilationManager.processResource((EfestoCompilationContext)context, new EfestoResource[]{toProcess});
        ((IterableAssert)Assertions.assertThat((Iterable)retrieved).isNotNull()).hasSize(1);
    }

    @Test
    void compileDrlFromPackageDescr() {
        String basePath = UUID.randomUUID().toString();
        DrlPackageDescrSetResource toProcess = new DrlPackageDescrSetResource(packageDescrs, basePath);
        Collection retrieved = compilationManager.processResource((EfestoCompilationContext)context, new EfestoResource[]{toProcess});
        ((IterableAssert)Assertions.assertThat((Iterable)retrieved).isNotNull()).hasSize(1);
    }
}

