/*
 * Decompiled with CFR 0.152.
 */
package org.kie.drl.engine.testingmodule.runtime;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.api.runtime.KieSession;
import org.kie.drl.engine.runtime.kiesession.local.model.EfestoInputDrlKieSessionLocal;
import org.kie.drl.engine.runtime.kiesession.local.model.EfestoOutputDrlKieSessionLocal;
import org.kie.drl.engine.testingmodule.utils.DrlTestUtils;
import org.kie.efesto.common.api.model.FRI;
import org.kie.efesto.runtimemanager.api.model.EfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoOutput;
import org.kie.efesto.runtimemanager.api.model.EfestoRuntimeContext;
import org.kie.efesto.runtimemanager.api.service.RuntimeManager;
import org.kie.efesto.runtimemanager.core.service.RuntimeManagerImpl;

class RuntimeDrlTest {
    private static RuntimeManager runtimeManager;
    private static EfestoRuntimeContext context;
    private static final String basePath = "TestingRule";

    RuntimeDrlTest() {
    }

    @BeforeAll
    static void setUp() {
        DrlTestUtils.refreshDrlIndexFile();
        runtimeManager = new RuntimeManagerImpl();
        context = EfestoRuntimeContext.buildWithParentClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    @Test
    void evaluateWithKieSessionLocalStaticCompilation() {
        EfestoInputDrlKieSessionLocal toEvaluate = new EfestoInputDrlKieSessionLocal(new FRI(basePath, "drl"), "");
        Collection output = runtimeManager.evaluateInput(context, new EfestoInput[]{toEvaluate});
        ((IterableAssert)Assertions.assertThat((Iterable)output).isNotNull()).hasSize(1);
        EfestoOutput retrievedRaw = (EfestoOutput)output.iterator().next();
        Assertions.assertThat((Object)retrievedRaw).isInstanceOf(EfestoOutputDrlKieSessionLocal.class);
        EfestoOutputDrlKieSessionLocal retrieved = (EfestoOutputDrlKieSessionLocal)retrievedRaw;
        ((ObjectAssert)Assertions.assertThat((Object)((KieSession)retrieved.getOutputData())).isNotNull()).isInstanceOf(KieSession.class);
    }
}

