/*
 * Decompiled with CFR 0.152.
 */
package org.kie.drl.engine.testingmodule.runtime;

import java.util.Collection;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.api.runtime.KieSession;
import org.kie.drl.api.identifiers.DrlIdFactory;
import org.kie.drl.api.identifiers.KieDrlComponentRoot;
import org.kie.drl.api.identifiers.LocalComponentIdDrl;
import org.kie.drl.engine.runtime.kiesession.local.model.EfestoInputDrlKieSessionLocal;
import org.kie.drl.engine.runtime.kiesession.local.model.EfestoOutputDrlKieSessionLocal;
import org.kie.drl.engine.testingmodule.utils.DrlTestUtils;
import org.kie.efesto.common.api.identifiers.EfestoAppRoot;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;
import org.kie.efesto.runtimemanager.api.model.EfestoInput;
import org.kie.efesto.runtimemanager.api.model.EfestoOutput;
import org.kie.efesto.runtimemanager.api.model.EfestoRuntimeContext;
import org.kie.efesto.runtimemanager.api.service.RuntimeManager;
import org.kie.efesto.runtimemanager.core.model.EfestoRuntimeContextUtils;
import org.kie.efesto.runtimemanager.core.service.RuntimeManagerImpl;

class RuntimeDrlTest {
    private static RuntimeManager runtimeManager;
    private static EfestoRuntimeContext context;
    private static final String basePath = "TestingRule";

    RuntimeDrlTest() {
    }

    @BeforeAll
    static void setUp() {
        DrlTestUtils.refreshDrlIndexFile();
        runtimeManager = new RuntimeManagerImpl();
        context = EfestoRuntimeContextUtils.buildWithParentClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    @Test
    void evaluateWithKieSessionLocalStaticCompilation() {
        LocalComponentIdDrl modelLocalUriId = ((DrlIdFactory)((KieDrlComponentRoot)new EfestoAppRoot().get(KieDrlComponentRoot.class)).get(DrlIdFactory.class)).get(basePath);
        EfestoInputDrlKieSessionLocal toEvaluate = new EfestoInputDrlKieSessionLocal((ModelLocalUriId)modelLocalUriId, "");
        Collection output = runtimeManager.evaluateInput(context, new EfestoInput[]{toEvaluate});
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)output).isNotNull()).hasSize(1);
        EfestoOutput retrievedRaw = (EfestoOutput)output.iterator().next();
        Assertions.assertThat((Object)retrievedRaw).isInstanceOf(EfestoOutputDrlKieSessionLocal.class);
        EfestoOutputDrlKieSessionLocal retrieved = (EfestoOutputDrlKieSessionLocal)retrievedRaw;
        ((ObjectAssert)Assertions.assertThat((Object)((KieSession)retrieved.getOutputData())).isNotNull()).isInstanceOf(KieSession.class);
    }
}

