/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.drools.client.home;

import com.google.gwt.core.client.GWT;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.guvnor.common.services.shared.security.KieWorkbenchACL;
import org.kie.workbench.common.screens.home.model.HomeModel;
import org.kie.workbench.common.screens.home.model.ModelUtils;
import org.kie.workbench.common.screens.home.model.Section;
import org.kie.workbench.common.screens.home.model.SectionEntry;
import org.kie.workbench.drools.client.resources.i18n.HomeConstants;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class HomeProducer {
    private HomeConstants constants = HomeConstants.INSTANCE;
    private HomeModel model;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private KieWorkbenchACL kieACL;

    public void init() {
        String url = GWT.getModuleBaseURL();
        this.model = new HomeModel(this.constants.homeTheKnowledgeLifeCycle());
        this.model.addCarouselEntry(ModelUtils.makeCarouselEntry((String)this.constants.homeAuthor(), (String)this.constants.homeAuthorCaption(), (String)(url + "/images/HandHome.jpg")));
        this.model.addCarouselEntry(ModelUtils.makeCarouselEntry((String)this.constants.homeDeploy(), (String)this.constants.homeDeployCaption(), (String)(url + "/images/HandHome.jpg")));
        Section s1 = new Section(this.constants.authoring());
        SectionEntry s1_a = ModelUtils.makeSectionEntry((String)this.constants.project_authoring(), (Command)new Command(){

            public void execute() {
                HomeProducer.this.placeManager.goTo("AuthoringPerspective");
            }
        });
        SectionEntry s1_b = ModelUtils.makeSectionEntry((String)this.constants.contributors(), (Command)new Command(){

            public void execute() {
                HomeProducer.this.placeManager.goTo("ContributorsPerspective");
            }
        });
        SectionEntry s1_d = ModelUtils.makeSectionEntry((String)this.constants.artifactRepository(), (Command)new Command(){

            public void execute() {
                HomeProducer.this.placeManager.goTo("org.guvnor.m2repo.client.perspectives.GuvnorM2RepoPerspective");
            }
        });
        SectionEntry s1_e = ModelUtils.makeSectionEntry((String)this.constants.administration(), (Command)new Command(){

            public void execute() {
                HomeProducer.this.placeManager.goTo("AdministrationPerspective");
            }
        });
        Section s2 = new Section(this.constants.deploy());
        SectionEntry s2_a = ModelUtils.makeSectionEntry((String)this.constants.ruleDeployments(), (Command)new Command(){

            public void execute() {
                HomeProducer.this.placeManager.goTo("ServerManagementPerspective");
            }
        });
        Section s3 = new Section(this.constants.tasks());
        SectionEntry s3_a = ModelUtils.makeSectionEntry((String)this.constants.Tasks_List(), (Command)new Command(){

            public void execute() {
                HomeProducer.this.placeManager.goTo("Tasks");
            }
        });
        s1.setRoles((Collection)this.kieACL.getGrantedRoles("wb_authoring"));
        s1_a.setRoles((Collection)this.kieACL.getGrantedRoles("wb_project_authoring"));
        s1_b.setRoles((Collection)this.kieACL.getGrantedRoles("wb_contributors"));
        s1_d.setRoles((Collection)this.kieACL.getGrantedRoles("wb_artifact_repository"));
        s1_e.setRoles((Collection)this.kieACL.getGrantedRoles("wb_administration"));
        s2.setRoles((Collection)this.kieACL.getGrantedRoles("wb_authoring"));
        s2_a.setRoles((Collection)this.kieACL.getGrantedRoles("wb_management"));
        s1.addEntry(s1_a);
        s1.addEntry(s1_b);
        s1.addEntry(s1_d);
        s1.addEntry(s1_e);
        s2.addEntry(s2_a);
        s3.addEntry(s3_a);
        this.model.addSection(s1);
        this.model.addSection(s2);
        this.model.addSection(s3);
    }

    @Produces
    public HomeModel getModel() {
        return this.model;
    }
}

