/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.drools.backend.server;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.screens.workitems.backend.server.WorkbenchConfigurationHelper;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.kie.workbench.screens.workbench.backend.BaseAppSetup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.services.cdi.ApplicationStarted;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;
import org.uberfire.io.IOService;

@Startup(value=StartupType.BOOTSTRAP)
@ApplicationScoped
public class AppSetup
extends BaseAppSetup {
    private static final Logger logger = LoggerFactory.getLogger(AppSetup.class);
    private static final String OU_NAME = "demo";
    private static final String OU_OWNER = "demo@demo.org";
    private Event<ApplicationStarted> applicationStartedEvent;
    private WorkbenchConfigurationHelper workbenchConfigurationHelper;

    protected AppSetup() {
    }

    @Inject
    public AppSetup(@Named(value="ioStrategy") IOService ioService, RepositoryService repositoryService, OrganizationalUnitService organizationalUnitService, KieProjectService projectService, ConfigurationService configurationService, ConfigurationFactory configurationFactory, Event<ApplicationStarted> applicationStartedEvent, WorkbenchConfigurationHelper workbenchConfigurationHelper) {
        super(ioService, repositoryService, organizationalUnitService, projectService, configurationService, configurationFactory);
        this.applicationStartedEvent = applicationStartedEvent;
        this.workbenchConfigurationHelper = workbenchConfigurationHelper;
    }

    @PostConstruct
    public void assertPlayground() {
        try {
            this.configurationService.startBatch();
            String exampleRepositoriesRoot = System.getProperty("org.kie.example.repositories");
            if (exampleRepositoriesRoot != null && !"".equalsIgnoreCase(exampleRepositoriesRoot)) {
                this.loadExampleRepositories(exampleRepositoriesRoot, OU_NAME, OU_OWNER, "git");
            } else if ("true".equalsIgnoreCase(System.getProperty("org.kie.example"))) {
                Repository exampleRepo = this.createRepository("repository1", "git", null, "", "");
                this.createOU(exampleRepo, "example", "");
                this.createProject(exampleRepo, "org.kie.example", "project1", "1.0.0-SNAPSHOT");
            }
            this.setupConfigurationGroup(ConfigType.GLOBAL, "settings", this.getGlobalConfiguration(), new ConfigItem[0]);
            this.setupConfigurationGroup(ConfigType.EDITOR, "work-items-editor-settings", this.workbenchConfigurationHelper.getWorkItemElementDefinitions(), new ConfigItem[0]);
            this.applicationStartedEvent.fire((Object)new ApplicationStarted());
        }
        catch (Exception e) {
            logger.error("Error during update config", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.configurationService.endBatch();
        }
    }

    protected ConfigGroup getGlobalConfiguration() {
        ConfigGroup group = this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, "settings", "");
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.dateformat", "dd-MMM-yyyy"));
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.datetimeformat", "dd-MMM-yyyy HH:mm:ss"));
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.defaultlanguage", "en"));
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.defaultcountry", "US"));
        group.addConfigItem(this.configurationFactory.newConfigItem("build.enable-incremental", "true"));
        group.addConfigItem(this.configurationFactory.newConfigItem("rule-modeller-onlyShowDSLStatements", "false"));
        group.addConfigItem(this.configurationFactory.newConfigItem("support.runtime.deploy", "false"));
        return group;
    }
}

