/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api.command;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.kie.remote.client.api.RemoteApiResponse;
import org.kie.remote.client.api.RemoteTaskService;
import org.kie.remote.client.api.exception.RemoteApiException;
import org.kie.remote.client.api.exception.RemoteCommunicationException;
import org.kie.remote.client.api.exception.RemoteTaskException;
import org.kie.remote.client.internal.RemoteClientException;
import org.kie.remote.client.jaxb.ConversionUtil;
import org.kie.remote.jaxb.gen.AddContentFromUserCommand;
import org.kie.remote.jaxb.gen.GetContentMapForUserCommand;
import org.kie.remote.jaxb.gen.NominateTaskCommand;
import org.kie.remote.jaxb.gen.OrganizationalEntity;
import org.kie.services.client.api.command.RemoteConfiguration;
import org.kie.services.client.api.command.TaskServiceClientCommandObject;

public class RemoteTaskServiceClientImpl
implements RemoteTaskService {
    private final TaskServiceClientCommandObject delegate;

    RemoteTaskServiceClientImpl(RemoteConfiguration config) {
        this.delegate = new TaskServiceClientCommandObject(config);
    }

    private static <T> RemoteApiResponse<T> createRemoteApiResponse(RemoteClientException rce) {
        Throwable exc;
        String message = rce.getShortMessage();
        if (message == null) {
            message = rce.getMessage();
        }
        if ((exc = rce.getCause()) == null) {
            exc = rce;
        }
        RemoteApiResponse response = rce instanceof RemoteTaskException ? new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.PERMISSIONS_FAILURE, message, exc) : (rce instanceof RemoteCommunicationException ? new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.COMMUNICATION_FAILURE, message, exc) : (rce instanceof RemoteApiException ? (exc instanceof RemoteClientException ? new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.SERVER_FAILURE, message, exc) : new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.CLIENT_FAILURE, message, exc)) : new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.UNKNOWN_FAILURE, message, exc)));
        return response;
    }

    @Override
    public RemoteApiResponse activate(long taskId) {
        RemoteApiResponse<Object> response;
        try {
            this.delegate.activate(taskId, this.delegate.getConfig().getUserName());
            response = new RemoteApiResponse();
        }
        catch (RemoteClientException rce) {
            response = RemoteTaskServiceClientImpl.createRemoteApiResponse(rce);
        }
        catch (Exception e) {
            response = new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.UNKNOWN_FAILURE, e);
        }
        return response;
    }

    @Override
    public RemoteApiResponse claim(long taskId) {
        RemoteApiResponse<Object> response;
        try {
            this.delegate.claim(taskId, this.delegate.getConfig().getUserName());
            response = new RemoteApiResponse();
        }
        catch (RemoteClientException rce) {
            response = RemoteTaskServiceClientImpl.createRemoteApiResponse(rce);
        }
        catch (Exception e) {
            response = new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.UNKNOWN_FAILURE, e);
        }
        return response;
    }

    @Override
    public RemoteApiResponse claimNextAvailable() {
        RemoteApiResponse<Object> response;
        try {
            this.delegate.claimNextAvailable(this.delegate.getConfig().getUserName());
            response = new RemoteApiResponse();
        }
        catch (RemoteClientException rce) {
            response = RemoteTaskServiceClientImpl.createRemoteApiResponse(rce);
        }
        catch (Exception e) {
            response = new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.UNKNOWN_FAILURE, e);
        }
        return response;
    }

    @Override
    public RemoteApiResponse complete(long taskId, Map<String, Object> data) {
        RemoteApiResponse<Object> response;
        try {
            this.delegate.complete(taskId, this.delegate.getConfig().getUserName(), data);
            response = new RemoteApiResponse();
        }
        catch (RemoteClientException rce) {
            response = RemoteTaskServiceClientImpl.createRemoteApiResponse(rce);
        }
        catch (Exception e) {
            response = new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.UNKNOWN_FAILURE, e);
        }
        return response;
    }

    @Override
    public RemoteApiResponse delegate(long taskId, String targetUserId) {
        RemoteApiResponse<Object> response;
        try {
            this.delegate.delegate(taskId, this.delegate.getConfig().getUserName(), targetUserId);
            response = new RemoteApiResponse();
        }
        catch (RemoteClientException rce) {
            response = RemoteTaskServiceClientImpl.createRemoteApiResponse(rce);
        }
        catch (Exception e) {
            response = new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.UNKNOWN_FAILURE, e);
        }
        return response;
    }

    @Override
    public RemoteApiResponse exit(long taskId) {
        RemoteApiResponse<Object> response;
        try {
            this.delegate.exit(taskId, this.delegate.getConfig().getUserName());
            response = new RemoteApiResponse();
        }
        catch (RemoteClientException rce) {
            response = RemoteTaskServiceClientImpl.createRemoteApiResponse(rce);
        }
        catch (Exception e) {
            response = new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.UNKNOWN_FAILURE, e);
        }
        return response;
    }

    @Override
    public RemoteApiResponse fail(long taskId) {
        return this.fail(taskId, null);
    }

    @Override
    public RemoteApiResponse fail(long taskId, Map<String, Object> faultData) {
        RemoteApiResponse<Object> response;
        try {
            this.delegate.fail(taskId, this.delegate.getConfig().getUserName(), faultData);
            response = new RemoteApiResponse();
        }
        catch (RemoteClientException rce) {
            response = RemoteTaskServiceClientImpl.createRemoteApiResponse(rce);
        }
        catch (Exception e) {
            response = new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.UNKNOWN_FAILURE, e);
        }
        return response;
    }

    @Override
    public RemoteApiResponse forward(long taskId, String targetEntityId) {
        RemoteApiResponse<Object> response;
        try {
            this.delegate.forward(taskId, this.delegate.getConfig().getUserName(), targetEntityId);
            response = new RemoteApiResponse();
        }
        catch (RemoteClientException rce) {
            response = RemoteTaskServiceClientImpl.createRemoteApiResponse(rce);
        }
        catch (Exception e) {
            response = new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.UNKNOWN_FAILURE, e);
        }
        return response;
    }

    @Override
    public RemoteApiResponse release(long taskId) {
        RemoteApiResponse<Object> response;
        try {
            this.delegate.release(taskId, this.delegate.getConfig().getUserName());
            response = new RemoteApiResponse();
        }
        catch (RemoteClientException rce) {
            response = RemoteTaskServiceClientImpl.createRemoteApiResponse(rce);
        }
        catch (Exception e) {
            response = new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.UNKNOWN_FAILURE, e);
        }
        return response;
    }

    @Override
    public RemoteApiResponse resume(long taskId) {
        RemoteApiResponse<Object> response;
        try {
            this.delegate.resume(taskId, this.delegate.getConfig().getUserName());
            response = new RemoteApiResponse();
        }
        catch (RemoteClientException rce) {
            response = RemoteTaskServiceClientImpl.createRemoteApiResponse(rce);
        }
        catch (Exception e) {
            response = new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.UNKNOWN_FAILURE, e);
        }
        return response;
    }

    @Override
    public RemoteApiResponse skip(long taskId) {
        RemoteApiResponse<Object> response;
        try {
            this.delegate.skip(taskId, this.delegate.getConfig().getUserName());
            response = new RemoteApiResponse();
        }
        catch (RemoteClientException rce) {
            response = RemoteTaskServiceClientImpl.createRemoteApiResponse(rce);
        }
        catch (Exception e) {
            response = new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.UNKNOWN_FAILURE, e);
        }
        return response;
    }

    @Override
    public RemoteApiResponse start(long taskId) {
        RemoteApiResponse<Object> response;
        try {
            this.delegate.start(taskId, this.delegate.getConfig().getUserName());
            response = new RemoteApiResponse();
        }
        catch (RemoteClientException rce) {
            response = RemoteTaskServiceClientImpl.createRemoteApiResponse(rce);
        }
        catch (Exception e) {
            response = new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.UNKNOWN_FAILURE, e);
        }
        return response;
    }

    @Override
    public RemoteApiResponse stop(long taskId) {
        RemoteApiResponse<Object> response;
        try {
            this.delegate.stop(taskId, this.delegate.getConfig().getUserName());
            response = new RemoteApiResponse();
        }
        catch (RemoteClientException rce) {
            response = RemoteTaskServiceClientImpl.createRemoteApiResponse(rce);
        }
        catch (Exception e) {
            response = new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.UNKNOWN_FAILURE, e);
        }
        return response;
    }

    @Override
    public RemoteApiResponse suspend(long taskId) {
        RemoteApiResponse<Object> response;
        try {
            this.delegate.suspend(taskId, this.delegate.getConfig().getUserName());
            response = new RemoteApiResponse();
        }
        catch (RemoteClientException rce) {
            response = RemoteTaskServiceClientImpl.createRemoteApiResponse(rce);
        }
        catch (Exception e) {
            response = new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.UNKNOWN_FAILURE, e);
        }
        return response;
    }

    @Override
    public RemoteApiResponse nominate(long taskId, String ... potentialOwnerUserIds) {
        RemoteApiResponse<Object> response;
        if (potentialOwnerUserIds == null || potentialOwnerUserIds.length == 0) {
            return new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.CLIENT_FAILURE, "Null or empty list of potential owner user ids received as argument");
        }
        try {
            NominateTaskCommand cmd = new NominateTaskCommand();
            cmd.setTaskId(taskId);
            cmd.setUserId(this.delegate.getConfig().getUserName());
            List<OrganizationalEntity> genOrgEntList = ConversionUtil.convertStringListToGenOrgEntList(Arrays.asList(potentialOwnerUserIds));
            if (genOrgEntList != null) {
                cmd.getPotentialOwners().addAll(genOrgEntList);
            }
            this.delegate.executeCommand(cmd);
            response = new RemoteApiResponse();
        }
        catch (RemoteClientException rce) {
            response = RemoteTaskServiceClientImpl.createRemoteApiResponse(rce);
        }
        catch (Exception e) {
            response = new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.UNKNOWN_FAILURE, e);
        }
        return response;
    }

    @Override
    public RemoteApiResponse<Long> addOutputContent(long taskId, Map<String, Object> params) {
        RemoteApiResponse<Long> response;
        if (params == null) {
            return new RemoteApiResponse<Long>(RemoteApiResponse.RemoteOperationStatus.CLIENT_FAILURE, "Null Map<String, Object> received as argument");
        }
        try {
            AddContentFromUserCommand cmd = new AddContentFromUserCommand();
            cmd.setTaskId(taskId);
            cmd.setUserId(this.delegate.getConfig().getUserName());
            cmd.setOutputContentMap(ConversionUtil.convertMapToJaxbStringObjectPairArray(params));
            Long contentId = (Long)this.delegate.executeCommand(cmd);
            response = new RemoteApiResponse<Long>(contentId);
        }
        catch (RemoteClientException rce) {
            response = RemoteTaskServiceClientImpl.createRemoteApiResponse(rce);
        }
        catch (Exception e) {
            response = new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.UNKNOWN_FAILURE, e);
        }
        return response;
    }

    @Override
    public RemoteApiResponse<Map<String, Object>> getOutputContentMap(long taskId) {
        RemoteApiResponse<Map<String, Object>> response;
        try {
            GetContentMapForUserCommand cmd = new GetContentMapForUserCommand();
            cmd.setTaskId(taskId);
            cmd.setUserId(this.delegate.getConfig().getUserName());
            Map outputContentMap = (Map)this.delegate.executeCommand(cmd);
            response = new RemoteApiResponse<Map>(outputContentMap);
        }
        catch (RemoteClientException rce) {
            response = RemoteTaskServiceClientImpl.createRemoteApiResponse(rce);
        }
        catch (Exception e) {
            response = new RemoteApiResponse(RemoteApiResponse.RemoteOperationStatus.UNKNOWN_FAILURE, e);
        }
        return response;
    }
}

