/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.engine.sort;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.dashbuilder.comparator.ComparatorUtils;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.sort.SortOrder;

public class DataSetRowComparator
implements Comparator<Integer> {
    protected List<DataColumn> columns = new ArrayList<DataColumn>();
    protected List<SortOrder> orders = new ArrayList<SortOrder>();

    public DataSetRowComparator criteria(DataColumn column, SortOrder order) {
        this.columns.add(column);
        this.orders.add(order);
        return this;
    }

    @Override
    public int compare(Integer row1, Integer row2) {
        if (this.columns.size() == 0) {
            return 0;
        }
        if (row1 == null && row2 != null) {
            return -1;
        }
        if (row1 != null && row2 == null) {
            return 1;
        }
        if (row1 == null) {
            return 0;
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            Comparable value2;
            DataColumn column = this.columns.get(i);
            SortOrder order = this.orders.get(i);
            Comparable value1 = (Comparable)column.getValues().get(row1);
            int comp = ComparatorUtils.compare(value1, value2 = (Comparable)column.getValues().get(row2), order.asInt());
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }
}

