/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.util.Map;
import org.jbpm.kie.services.impl.VariablesAware;
import org.jbpm.kie.services.impl.cmd.StartProcessInstanceWithParentCommand;
import org.jbpm.services.api.AdHocProcessService;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.DeployedUnit;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdHocProcessServiceImpl
implements AdHocProcessService,
VariablesAware {
    private static final Logger logger = LoggerFactory.getLogger(AdHocProcessServiceImpl.class);
    protected DeploymentService deploymentService;
    protected RuntimeDataService dataService;

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public void setDataService(RuntimeDataService dataService) {
        this.dataService = dataService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long startProcess(String deploymentId, String processId, CorrelationKey correlationKey, Map<String, Object> params, Long parentProcessInstanceId) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            throw new DeploymentNotFoundException("No deployments available for " + deploymentId);
        }
        if (!deployedUnit.isActive()) {
            throw new DeploymentNotFoundException("Deployments " + deploymentId + " is not active");
        }
        RuntimeManager manager = deployedUnit.getRuntimeManager();
        params = this.process(params, ((InternalRuntimeManager)manager).getEnvironment().getClassLoader());
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = engine.getKieSession();
        ProcessInstance pi = null;
        try {
            pi = ((CorrelationAwareProcessRuntime)ksession).createProcessInstance(processId, correlationKey, params);
            pi = (ProcessInstance)ksession.execute((Command)new StartProcessInstanceWithParentCommand(pi.getId(), parentProcessInstanceId));
            Long l = pi.getId();
            return l;
        }
        finally {
            this.disposeRuntimeEngine(manager, engine);
        }
    }

    @Override
    public <T> T process(T variables, ClassLoader cl) {
        return variables;
    }

    protected void disposeRuntimeEngine(RuntimeManager manager, RuntimeEngine engine) {
        manager.disposeRuntimeEngine(engine);
    }
}

