/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.collect.Lists;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.servlet.AbstractServletPipeline;
import com.google.inject.servlet.ServletDefinition;
import java.util.ArrayList;

@Singleton
class ManagedServletPipeline
extends AbstractServletPipeline {
    private final ServletDefinition[] servletDefinitions;
    private static final TypeLiteral<ServletDefinition> SERVLET_DEFS = TypeLiteral.get(ServletDefinition.class);

    @Inject
    public ManagedServletPipeline(Injector injector) {
        this.servletDefinitions = ManagedServletPipeline.collectServletDefinitions(injector);
    }

    @Override
    protected boolean hasServletsMapped() {
        return this.servletDefinitions.length > 0;
    }

    @Override
    protected ServletDefinition[] servletDefinitions() {
        return this.servletDefinitions;
    }

    private static ServletDefinition[] collectServletDefinitions(Injector injector) {
        ArrayList servletDefinitions = Lists.newArrayList();
        for (Binding entry : injector.findBindingsByType(SERVLET_DEFS)) {
            servletDefinitions.add(entry.getProvider().get());
        }
        return servletDefinitions.toArray(new ServletDefinition[servletDefinitions.size()]);
    }
}

