/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core.jmx;

import java.util.ArrayList;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.quartz.Trigger;
import org.quartz.core.jmx.JobDataMapSupport;

public class TriggerSupport {
    private static final String COMPOSITE_TYPE_NAME = "Trigger";
    private static final String COMPOSITE_TYPE_DESCRIPTION = "Trigger Details";
    private static final String[] ITEM_NAMES = new String[]{"name", "group", "jobName", "jobGroup", "description", "jobDataMap", "volatility", "calendarName", "fireInstanceId", "misfireInstruction", "priority", "startTime", "endTime", "nextFireTime", "previousFireTime", "finalFireTime"};
    private static final String[] ITEM_DESCRIPTIONS = new String[]{"name", "group", "jobName", "jobGroup", "description", "jobDataMap", "volatility", "calendarName", "fireInstanceId", "misfireInstruction", "priority", "startTime", "endTime", "nextFireTime", "previousFireTime", "finalFireTime"};
    private static final OpenType[] ITEM_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, JobDataMapSupport.TABULAR_TYPE, SimpleType.BOOLEAN, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.DATE, SimpleType.DATE, SimpleType.DATE, SimpleType.DATE, SimpleType.DATE};
    private static final CompositeType COMPOSITE_TYPE;
    private static final String TABULAR_TYPE_NAME = "Trigger collection";
    private static final String TABULAR_TYPE_DESCRIPTION = "Trigger collection";
    private static final String[] INDEX_NAMES;
    private static final TabularType TABULAR_TYPE;

    public static CompositeData toCompositeData(Trigger trigger) {
        try {
            return new CompositeDataSupport(COMPOSITE_TYPE, ITEM_NAMES, new Object[]{trigger.getName(), trigger.getGroup(), trigger.getJobName(), trigger.getJobGroup(), trigger.getDescription(), JobDataMapSupport.toTabularData(trigger.getJobDataMap()), trigger.isVolatile(), trigger.getCalendarName(), trigger.getFireInstanceId(), trigger.getMisfireInstruction(), trigger.getPriority(), trigger.getStartTime(), trigger.getEndTime(), trigger.getNextFireTime(), trigger.getPreviousFireTime(), trigger.getFinalFireTime()});
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public static TabularData toTabularData(Trigger[] triggers) {
        TabularDataSupport tData = new TabularDataSupport(TABULAR_TYPE);
        if (triggers != null) {
            ArrayList<CompositeData> list = new ArrayList<CompositeData>();
            for (Trigger trigger : triggers) {
                list.add(TriggerSupport.toCompositeData(trigger));
            }
            tData.putAll(list.toArray(new CompositeData[list.size()]));
        }
        return tData;
    }

    static {
        INDEX_NAMES = new String[]{"name", "group"};
        try {
            COMPOSITE_TYPE = new CompositeType(COMPOSITE_TYPE_NAME, COMPOSITE_TYPE_DESCRIPTION, ITEM_NAMES, ITEM_DESCRIPTIONS, ITEM_TYPES);
            TABULAR_TYPE = new TabularType("Trigger collection", "Trigger collection", COMPOSITE_TYPE, INDEX_NAMES);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }
}

