/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManagerFactory;
import org.jbpm.services.task.audit.impl.model.AuditTaskImpl;
import org.jbpm.services.task.audit.impl.model.TaskEventImpl;
import org.jbpm.services.task.audit.variable.TaskIndexerManager;
import org.jbpm.services.task.lifecycle.listeners.TaskLifeCycleEventListener;
import org.jbpm.services.task.persistence.PersistableEventListener;
import org.jbpm.services.task.utils.ClassUtil;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.TaskContext;
import org.kie.internal.task.api.TaskPersistenceContext;
import org.kie.internal.task.api.TaskVariable;
import org.kie.internal.task.api.model.TaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPATaskLifeCycleEventListener
extends PersistableEventListener
implements TaskLifeCycleEventListener {
    private static final Logger logger = LoggerFactory.getLogger(JPATaskLifeCycleEventListener.class);
    private static final List<String> SKIPPED_TASK_VARIABLES = Arrays.asList("ActorId", "TaskName", "NodeName");

    public JPATaskLifeCycleEventListener(boolean flag) {
        super(null);
    }

    public JPATaskLifeCycleEventListener(EntityManagerFactory emf) {
        super(emf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskStartedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.STARTED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskActivatedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.ACTIVATED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskClaimedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.CLAIMED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskSkippedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.SKIPPED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskStoppedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.STOPPED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskCompletedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.COMPLETED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskFailedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.FAILED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskAddedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            if (ti.getTaskData().getProcessId() != null) {
                userId = ti.getTaskData().getProcessId();
            }
            AuditTaskImpl auditTaskImpl = new AuditTaskImpl(ti.getId(), ti.getName(), ti.getTaskData().getStatus().name(), ti.getTaskData().getActivationTime(), ti.getTaskData().getActualOwner() != null ? ti.getTaskData().getActualOwner().getId() : "", ti.getDescription(), ti.getPriority(), ti.getTaskData().getCreatedBy() != null ? ti.getTaskData().getCreatedBy().getId() : "", ti.getTaskData().getCreatedOn(), ti.getTaskData().getExpirationTime(), ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getProcessId(), ti.getTaskData().getProcessSessionId(), ti.getTaskData().getDeploymentId(), ti.getTaskData().getParentId(), ti.getTaskData().getWorkItemId());
            persistenceContext.persist((Object)auditTaskImpl);
            persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.ADDED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskExitedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.EXITED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setName(ti.getName());
            auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
            auditTaskImpl.setPriority(ti.getPriority());
            auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskReleasedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setName(ti.getName());
            auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
            auditTaskImpl.setPriority(ti.getPriority());
            auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskResumedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.RESUMED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setName(ti.getName());
            auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
            auditTaskImpl.setPriority(ti.getPriority());
            auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskSuspendedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.SUSPENDED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setName(ti.getName());
            auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
            auditTaskImpl.setPriority(ti.getPriority());
            auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskForwardedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.FORWARDED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setName(ti.getName());
            auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
            auditTaskImpl.setPriority(ti.getPriority());
            auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskDelegatedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.DELEGATED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setName(ti.getName());
            auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
            auditTaskImpl.setPriority(ti.getPriority());
            auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskNominatedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.NOMINATED, userId, new Date()));
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setName(ti.getName());
            auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
            auditTaskImpl.setPriority(ti.getPriority());
            auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    protected AuditTaskImpl getAuditTask(TaskEvent event, TaskPersistenceContext persistenceContext, Task ti) {
        AuditTaskImpl auditTaskImpl = (AuditTaskImpl)persistenceContext.queryWithParametersInTransaction("getAuditTaskById", true, (Map)persistenceContext.addParametersToMap(new Object[]{"taskId", ti.getId()}), ClassUtil.castClass(AuditTaskImpl.class));
        return auditTaskImpl;
    }

    public void beforeTaskActivatedEvent(TaskEvent event) {
    }

    public void beforeTaskClaimedEvent(TaskEvent event) {
    }

    public void beforeTaskSkippedEvent(TaskEvent event) {
    }

    public void beforeTaskStartedEvent(TaskEvent event) {
    }

    public void beforeTaskStoppedEvent(TaskEvent event) {
    }

    public void beforeTaskCompletedEvent(TaskEvent event) {
    }

    public void beforeTaskFailedEvent(TaskEvent event) {
    }

    public void beforeTaskAddedEvent(TaskEvent event) {
    }

    public void beforeTaskExitedEvent(TaskEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeTaskReleasedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.RELEASED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    public void beforeTaskResumedEvent(TaskEvent event) {
    }

    public void beforeTaskSuspendedEvent(TaskEvent event) {
    }

    public void beforeTaskForwardedEvent(TaskEvent event) {
    }

    public void beforeTaskDelegatedEvent(TaskEvent event) {
    }

    public void beforeTaskNominatedEvent(TaskEvent event) {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj instanceof JPATaskLifeCycleEventListener;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((Object)((Object)this)).getClass().getName().hashCode();
        return result;
    }

    public void beforeTaskUpdatedEvent(TaskEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskUpdatedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            String message;
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            if (ti.getDescription() != null && !ti.getDescription().equals(auditTaskImpl.getDescription()) || ti.getDescription() == null && auditTaskImpl.getDescription() != null) {
                message = "Updated Description {From: " + auditTaskImpl.getDescription() + ", to: " + ti.getDescription() + "}";
                persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.UPDATED, (Long)ti.getTaskData().getProcessInstanceId(), (Long)ti.getTaskData().getWorkItemId(), userId, message));
            }
            if (ti.getName() != null && !ti.getName().equals(auditTaskImpl.getName()) || ti.getName() == null && auditTaskImpl.getName() != null) {
                message = "Updated Name {From: " + auditTaskImpl.getName() + ", to: " + ti.getName() + "}";
                persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.UPDATED, (Long)ti.getTaskData().getProcessInstanceId(), (Long)ti.getTaskData().getWorkItemId(), userId, message));
            }
            if (auditTaskImpl.getPriority() != ti.getPriority().intValue()) {
                message = "Updated Priority {From: " + auditTaskImpl.getPriority() + ", to: " + ti.getPriority() + "}";
                persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.UPDATED, (Long)ti.getTaskData().getProcessInstanceId(), (Long)ti.getTaskData().getWorkItemId(), userId, message));
            }
            if (auditTaskImpl.getDueDate() != null && ti.getTaskData().getExpirationTime() != null && auditTaskImpl.getDueDate().getTime() != ti.getTaskData().getExpirationTime().getTime() || auditTaskImpl.getDueDate() == null && ti.getTaskData().getExpirationTime() != null || auditTaskImpl.getDueDate() != null && ti.getTaskData().getExpirationTime() == null) {
                message = "Updated DueDate {From: " + auditTaskImpl.getDueDate() + ", to: " + ti.getTaskData().getExpirationTime() + "}";
                persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.UPDATED, (Long)ti.getTaskData().getProcessInstanceId(), (Long)ti.getTaskData().getWorkItemId(), userId, message));
            }
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setName(ti.getName());
            auditTaskImpl.setPriority(ti.getPriority());
            auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            persistenceContext.merge((Object)auditTaskImpl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    public void beforeTaskReassignedEvent(TaskEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTaskReassignedEvent(TaskEvent event) {
        String userId = event.getTaskContext().getUserId();
        Task ti = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        try {
            persistenceContext.persist((Object)new TaskEventImpl(ti.getId(), TaskEvent.TaskEventType.DELEGATED, ti.getTaskData().getProcessInstanceId(), ti.getTaskData().getWorkItemId(), userId));
            AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, ti);
            if (auditTaskImpl == null) {
                logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)ti.getId(), (Object)ti.getName());
                return;
            }
            auditTaskImpl.setDescription(ti.getDescription());
            auditTaskImpl.setName(ti.getName());
            auditTaskImpl.setActivationTime(ti.getTaskData().getActivationTime());
            auditTaskImpl.setPriority(ti.getPriority());
            auditTaskImpl.setDueDate(ti.getTaskData().getExpirationTime());
            auditTaskImpl.setStatus(ti.getTaskData().getStatus().name());
            auditTaskImpl.setActualOwner(this.getActualOwner(ti));
            auditTaskImpl.setLastModificationDate(event.getEventDate());
            persistenceContext.merge((Object)auditTaskImpl);
        }
        finally {
            this.cleanup(persistenceContext);
        }
    }

    public void beforeTaskNotificationEvent(TaskEvent event) {
    }

    public void afterTaskNotificationEvent(TaskEvent event) {
    }

    public void afterTaskOutputVariableChangedEvent(TaskEvent event, Map<String, Object> variables) {
        String userId = event.getTaskContext().getUserId();
        Task task = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", TaskVariable.VariableType.OUTPUT);
        params.put("taskId", task.getId());
        int removed = persistenceContext.executeUpdate("DeleteTaskVariableForTask", params);
        logger.debug("Deleted {} output variables logs for task id {}", (Object)removed, (Object)task.getId());
        if (variables == null || variables.isEmpty()) {
            return;
        }
        this.indexAndPersistVariables(task, variables, persistenceContext, TaskVariable.VariableType.OUTPUT);
        String message = "Task output data updated";
        persistenceContext.persist((Object)new TaskEventImpl(task.getId(), TaskEvent.TaskEventType.UPDATED, (Long)task.getTaskData().getProcessInstanceId(), (Long)task.getTaskData().getWorkItemId(), userId, message));
        AuditTaskImpl auditTaskImpl = this.getAuditTask(event, persistenceContext, task);
        if (auditTaskImpl == null) {
            logger.warn("Unable find audit task entry for task id {} '{}', skipping audit task update", (Object)task.getId(), (Object)task.getName());
            return;
        }
        auditTaskImpl.setLastModificationDate(event.getEventDate());
        persistenceContext.merge((Object)auditTaskImpl);
    }

    public void afterTaskInputVariableChangedEvent(TaskEvent event, Map<String, Object> variables) {
        if (variables == null || variables.isEmpty()) {
            return;
        }
        Task task = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        this.indexAndPersistVariables(task, variables, persistenceContext, TaskVariable.VariableType.INPUT);
    }

    protected void indexAndPersistVariables(Task task, Map<String, Object> variables, TaskPersistenceContext persistenceContext, TaskVariable.VariableType type) {
        TaskIndexerManager manager = TaskIndexerManager.get();
        for (Map.Entry<String, Object> variable : variables.entrySet()) {
            List<TaskVariable> taskVars;
            if (SKIPPED_TASK_VARIABLES.contains(variable.getKey()) || variable.getValue() == null || (taskVars = manager.index(task, variable.getKey(), variable.getValue())) == null) continue;
            for (TaskVariable tVariable : taskVars) {
                tVariable.setType(type);
                persistenceContext.persist((Object)tVariable);
            }
        }
    }

    public void afterTaskAssignmentsAddedEvent(TaskEvent event, TaskLifeCycleEventListener.AssignmentType type, List<OrganizationalEntity> entities) {
        this.assignmentsUpadted(event, type, entities, "] have been added");
    }

    public void afterTaskAssignmentsRemovedEvent(TaskEvent event, TaskLifeCycleEventListener.AssignmentType type, List<OrganizationalEntity> entities) {
        this.assignmentsUpadted(event, type, entities, "] have been removed");
    }

    protected void assignmentsUpadted(TaskEvent event, TaskLifeCycleEventListener.AssignmentType type, List<OrganizationalEntity> entities, String messageSufix) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        String userId = event.getTaskContext().getUserId();
        Task task = event.getTask();
        TaskPersistenceContext persistenceContext = this.getPersistenceContext(((TaskContext)event.getTaskContext()).getPersistenceContext());
        StringBuilder message = new StringBuilder();
        switch (type) {
            case POT_OWNER: {
                message.append("Potential owners [");
                break;
            }
            case EXCL_OWNER: {
                message.append("Excluded owners [");
                break;
            }
            case ADMIN: {
                message.append("Business administrators [");
                break;
            }
        }
        String entitiesAsString = entities.stream().map(oe -> oe.getId()).collect(Collectors.joining(","));
        message.append(entitiesAsString);
        message.append(messageSufix);
        persistenceContext.persist((Object)new TaskEventImpl(task.getId(), TaskEvent.TaskEventType.UPDATED, (Long)task.getTaskData().getProcessInstanceId(), (Long)task.getTaskData().getWorkItemId(), userId, message.toString()));
    }

    protected String getActualOwner(Task ti) {
        String userId = "";
        if (ti.getTaskData().getActualOwner() != null) {
            userId = ti.getTaskData().getActualOwner().getId();
        }
        return userId;
    }
}

