/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.TransactionRequiredException;
import javax.transaction.UserTransaction;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.runtime.process.InternalProcessRuntime;
import org.drools.persistence.api.TransactionManager;
import org.jbpm.process.audit.AbstractAuditLogger;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.variable.ProcessIndexerManager;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.kie.api.event.KieRuntimeEvent;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.event.process.SLAViolatedEvent;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAWorkingMemoryDbLogger
extends AbstractAuditLogger {
    private static final Logger logger = LoggerFactory.getLogger(JPAWorkingMemoryDbLogger.class);
    private static final String[] KNOWN_UT_JNDI_KEYS = new String[]{"UserTransaction", "java:jboss/UserTransaction", System.getProperty("jbpm.ut.jndi.lookup")};
    private boolean isJTA = true;
    private boolean sharedEM = false;
    private EntityManagerFactory emf;
    private ProcessIndexerManager indexManager = ProcessIndexerManager.get();

    public JPAWorkingMemoryDbLogger(WorkingMemory workingMemory) {
        super(workingMemory);
        InternalProcessRuntime processRuntime = ((InternalWorkingMemory)workingMemory).getProcessRuntime();
        if (processRuntime != null) {
            processRuntime.addEventListener((ProcessEventListener)this);
        }
    }

    public JPAWorkingMemoryDbLogger(KieSession session) {
        Environment env = session.getEnvironment();
        this.internalSetIsJTA(env);
        session.addEventListener((ProcessEventListener)this);
    }

    public JPAWorkingMemoryDbLogger(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public JPAWorkingMemoryDbLogger() {
    }

    public JPAWorkingMemoryDbLogger(EntityManagerFactory emf, Environment env) {
        this.emf = emf;
        this.internalSetIsJTA(env);
    }

    public JPAWorkingMemoryDbLogger(Environment env) {
        this.internalSetIsJTA(env);
    }

    private void internalSetIsJTA(Environment env) {
        Boolean bool = (Boolean)env.get("IS_JTA_TRANSACTION");
        if (bool != null) {
            this.isJTA = bool;
        }
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        NodeInstanceLog log = (NodeInstanceLog)this.builder.buildEvent(event);
        this.persist(log, (KieRuntimeEvent)event);
        ((NodeInstanceImpl)event.getNodeInstance()).getMetaData().put("NodeInstanceLog", log);
    }

    public void afterNodeLeft(ProcessNodeLeftEvent event) {
        NodeInstanceLog log = (NodeInstanceLog)this.builder.buildEvent(event, null);
        this.persist(log, (KieRuntimeEvent)event);
    }

    public void afterVariableChanged(ProcessVariableChangedEvent event) {
        List<VariableInstanceLog> variables = this.indexManager.index(this.getBuilder(), event);
        for (VariableInstanceLog log : variables) {
            this.persist(log, (KieRuntimeEvent)event);
        }
    }

    public void beforeProcessStarted(ProcessStartedEvent event) {
        ProcessInstanceLog log = (ProcessInstanceLog)this.builder.buildEvent(event);
        this.persist(log, (KieRuntimeEvent)event);
        ((ProcessInstanceImpl)event.getProcessInstance()).getMetaData().put("ProcessInstanceLog", log);
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        List result;
        long processInstanceId = event.getProcessInstance().getId();
        EntityManager em = this.getEntityManager((KieRuntimeEvent)event);
        Object tx = this.joinTransaction(em);
        ProcessInstanceLog log = (ProcessInstanceLog)((ProcessInstanceImpl)event.getProcessInstance()).getMetaData().get("ProcessInstanceLog");
        if (log == null && (result = em.createQuery("from ProcessInstanceLog as log where log.processInstanceId = :piId and log.end is null").setParameter("piId", (Object)processInstanceId).getResultList()) != null && result.size() != 0) {
            log = (ProcessInstanceLog)result.get(result.size() - 1);
        }
        if (log != null) {
            log = (ProcessInstanceLog)this.builder.buildEvent(event, (Object)log);
            em.merge((Object)log);
        }
        this.leaveTransaction(em, tx);
    }

    public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
        NodeInstanceLog log = (NodeInstanceLog)((NodeInstanceImpl)event.getNodeInstance()).getMetaData().get("NodeInstanceLog");
        this.builder.buildEvent(event, (Object)log);
    }

    public void afterSLAViolated(SLAViolatedEvent event) {
        List result;
        if (event.getNodeInstance() != null) {
            return;
        }
        long processInstanceId = event.getProcessInstance().getId();
        EntityManager em = this.getEntityManager((KieRuntimeEvent)event);
        Object tx = this.joinTransaction(em);
        ProcessInstanceLog log = (ProcessInstanceLog)((ProcessInstanceImpl)event.getProcessInstance()).getMetaData().get("ProcessInstanceLog");
        if (log == null && (result = em.createQuery("from ProcessInstanceLog as log where log.processInstanceId = :piId and log.end is null").setParameter("piId", (Object)processInstanceId).getResultList()) != null && result.size() != 0) {
            log = (ProcessInstanceLog)result.get(result.size() - 1);
        }
        if (log != null) {
            log.setSlaCompliance(((ProcessInstance)event.getProcessInstance()).getSlaCompliance());
            em.merge((Object)log);
        }
        this.leaveTransaction(em, tx);
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
    }

    public void beforeVariableChanged(ProcessVariableChangedEvent event) {
    }

    public void afterProcessStarted(ProcessStartedEvent event) {
    }

    public void beforeProcessCompleted(ProcessCompletedEvent event) {
    }

    public void dispose() {
    }

    private void persist(Object entity, KieRuntimeEvent event) {
        EntityManager em = this.getEntityManager(event);
        Object tx = this.joinTransaction(em);
        em.persist(entity);
        this.leaveTransaction(em, tx);
    }

    private EntityManager getEntityManager(KieRuntimeEvent event) {
        Environment env = event.getKieRuntime().getEnvironment();
        this.sharedEM = false;
        if (this.emf != null) {
            return this.emf.createEntityManager();
        }
        if (env != null) {
            EntityManagerFactory emf = (EntityManagerFactory)env.get("org.kie.api.persistence.jpa.EntityManagerFactory");
            EntityManager em = this.getEntityManagerFromTransaction(env);
            if (em != null && em.isOpen() && em.getEntityManagerFactory().equals(emf)) {
                this.sharedEM = true;
                return em;
            }
            em = (EntityManager)env.get("org.kie.api.persistence.jpa.CmdScopedEntityManager");
            if (em != null) {
                this.sharedEM = true;
                return em;
            }
            if (emf != null) {
                return emf.createEntityManager();
            }
        }
        throw new RuntimeException("Could not find or create a new EntityManager!");
    }

    protected EntityManager getEntityManagerFromTransaction(Environment env) {
        if (env.get("org.kie.transaction.TransactionManager") instanceof TransactionManager) {
            TransactionManager txm = (TransactionManager)env.get("org.kie.transaction.TransactionManager");
            EntityManager em = (EntityManager)txm.getResource((Object)"org.kie.api.persistence.jpa.CmdScopedEntityManager");
            return em;
        }
        return null;
    }

    private Object joinTransaction(EntityManager em) {
        boolean newTx = false;
        UserTransaction ut = null;
        if (this.isJTA) {
            block7: {
                try {
                    em.joinTransaction();
                }
                catch (TransactionRequiredException e) {
                    ut = JPAWorkingMemoryDbLogger.findUserTransaction();
                    try {
                        if (ut != null && ut.getStatus() == 6) {
                            ut.begin();
                            newTx = true;
                            em.joinTransaction();
                        }
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException("Unable to find or open a transaction: " + ex.getMessage(), ex);
                    }
                    if (newTx) break block7;
                    throw e;
                }
            }
            if (newTx) {
                return ut;
            }
        }
        return null;
    }

    private void leaveTransaction(EntityManager em, Object transaction) {
        if (this.isJTA) {
            try {
                if (transaction != null) {
                    ((UserTransaction)transaction).commit();
                }
            }
            catch (Exception e) {
                logger.error("Unable to commit transaction: ", (Throwable)e);
            }
        } else if (transaction != null) {
            ((EntityTransaction)transaction).commit();
        }
        if (!this.sharedEM) {
            try {
                em.flush();
                em.close();
            }
            catch (Exception e) {
                logger.error("Unable to close created EntityManager: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    protected static UserTransaction findUserTransaction() {
        InitialContext context = null;
        try {
            context = new InitialContext();
            return (UserTransaction)context.lookup("java:comp/UserTransaction");
        }
        catch (NamingException ex) {
            for (String utLookup : KNOWN_UT_JNDI_KEYS) {
                if (utLookup == null) continue;
                try {
                    UserTransaction ut = (UserTransaction)context.lookup(utLookup);
                    return ut;
                }
                catch (NamingException e) {
                    logger.debug("User Transaction not found in JNDI under {}", (Object)utLookup);
                }
            }
            logger.warn("No user transaction found under known names");
            return null;
        }
    }
}

