/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.core.util;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.process.workitem.core.util.Wid;

public class WidInfo {
    private String widfile;
    private String name;
    private String displayName;
    private String category;
    private String icon;
    private String description;
    private String defaultHandler;
    private Map<String, InternalWidParamsAndResults> parameters = new HashMap<String, InternalWidParamsAndResults>();
    private Map<String, InternalWidParameterValues> parameterValues = new HashMap<String, InternalWidParameterValues>();
    private Map<String, InternalWidParamsAndResults> results = new HashMap<String, InternalWidParamsAndResults>();
    private Map<String, InternalWidMavenDependencies> mavenDepends = new HashMap<String, InternalWidMavenDependencies>();

    public WidInfo(List<Wid> wids) {
        for (Wid wid : wids) {
            this.widfile = this.setParamValue(this.widfile, wid.widfile());
            this.name = this.setParamValue(this.name, wid.name());
            this.displayName = this.setParamValue(this.displayName, wid.displayName());
            this.category = this.setParamValue(this.category, wid.category());
            this.icon = this.setParamValue(this.icon, wid.icon());
            this.description = this.setParamValue(this.description, wid.description());
            this.defaultHandler = this.setParamValue(this.defaultHandler, wid.defaultHandler());
            if (wid.parameters().length > 0) {
                for (Annotation annotation : wid.parameters()) {
                    this.parameters.put(annotation.name(), new InternalWidParamsAndResults(annotation.name(), annotation.type()));
                }
            }
            if (wid.parameterValues().length > 0) {
                for (Annotation annotation : wid.parameterValues()) {
                    this.parameterValues.put(annotation.parameterName(), new InternalWidParameterValues(annotation.parameterName(), annotation.values()));
                }
            }
            if (wid.results().length > 0) {
                for (Annotation annotation : wid.results()) {
                    this.results.put(annotation.name(), new InternalWidParamsAndResults(annotation.name(), annotation.type()));
                }
            }
            if (wid.mavenDepends().length <= 0) continue;
            for (Annotation annotation : wid.mavenDepends()) {
                this.mavenDepends.put(annotation.group() + "." + annotation.artifact(), new InternalWidMavenDependencies(annotation.group(), annotation.artifact(), annotation.version()));
            }
        }
    }

    private String setParamValue(String origVal, String newVal) {
        if (newVal != null && !newVal.isEmpty()) {
            return newVal;
        }
        return origVal == null || origVal.isEmpty() ? "" : origVal;
    }

    public String getWidfile() {
        return this.widfile;
    }

    public void setWidfile(String widfile) {
        this.widfile = widfile;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefaultHandler() {
        return this.defaultHandler;
    }

    public void setDefaultHandler(String defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public Map<String, InternalWidParamsAndResults> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, InternalWidParamsAndResults> parameters) {
        this.parameters = parameters;
    }

    public Map<String, InternalWidParameterValues> getParameterValues() {
        return this.parameterValues;
    }

    public void setParameterValues(Map<String, InternalWidParameterValues> parameterValues) {
        this.parameterValues = parameterValues;
    }

    public Map<String, InternalWidParamsAndResults> getResults() {
        return this.results;
    }

    public void setResults(Map<String, InternalWidParamsAndResults> results) {
        this.results = results;
    }

    public Map<String, InternalWidMavenDependencies> getMavenDepends() {
        return this.mavenDepends;
    }

    public void setMavenDepends(Map<String, InternalWidMavenDependencies> mavenDepends) {
        this.mavenDepends = mavenDepends;
    }

    public class InternalWidMavenDependencies {
        private String group;
        private String artifact;
        private String version;

        public InternalWidMavenDependencies(String group, String artifact, String version) {
            this.group = group;
            this.artifact = artifact;
            this.version = version;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getArtifact() {
            return this.artifact;
        }

        public void setArtifact(String artifact) {
            this.artifact = artifact;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }

    private class InternalWidParameterValues {
        private String parameterName;
        private String values;

        public InternalWidParameterValues(String parameterName, String values) {
            this.parameterName = parameterName;
            this.values = values;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public String getValues() {
            return this.values;
        }

        public void setValues(String values) {
            this.values = values;
        }
    }

    private class InternalWidParamsAndResults {
        private String name;
        private String type;

        public InternalWidParamsAndResults(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

