/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.deadlines.notifications.impl.email;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.jbpm.services.task.deadlines.NotificationListener;
import org.jbpm.services.task.deadlines.notifications.impl.email.EmailSessionProducer;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.UserInfo;
import org.kie.internal.task.api.model.EmailNotification;
import org.kie.internal.task.api.model.EmailNotificationHeader;
import org.kie.internal.task.api.model.InternalOrganizationalEntity;
import org.kie.internal.task.api.model.Language;
import org.kie.internal.task.api.model.NotificationEvent;
import org.mvel2.templates.TemplateRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailNotificationListener
implements NotificationListener {
    private static final Logger logger = LoggerFactory.getLogger(EmailNotificationListener.class);
    private Session mailSession = EmailSessionProducer.produceSession();

    @Override
    public void onNotification(NotificationEvent event, UserInfo userInfo) {
        if (userInfo == null || this.mailSession == null) {
            logger.info("Missing mail session or userinfo - skipping email notification listener processing");
            return;
        }
        if (event.getNotification() instanceof EmailNotification) {
            EmailNotification notification = (EmailNotification)event.getNotification();
            Task task = event.getTask();
            HashMap<String, List<User>> users = new HashMap<String, List<User>>();
            for (OrganizationalEntity entity : notification.getBusinessAdministrators()) {
                if (entity instanceof Group) {
                    this.buildMapByLanguage(users, (Group)entity, userInfo);
                    continue;
                }
                this.buildMapByLanguage(users, (User)entity, userInfo);
            }
            for (OrganizationalEntity entity : notification.getRecipients()) {
                if (entity instanceof Group) {
                    this.buildMapByLanguage(users, (Group)entity, userInfo);
                    continue;
                }
                this.buildMapByLanguage(users, (User)entity, userInfo);
            }
            Map variables = event.getContent();
            Map headers = notification.getEmailHeaders();
            Iterator it = users.entrySet().iterator();
            while (it.hasNext()) {
                try {
                    User user;
                    Map.Entry entry = it.next();
                    Language lang = TaskModelProvider.getFactory().newLanguage();
                    lang.setMapkey((String)entry.getKey());
                    EmailNotificationHeader header = (EmailNotificationHeader)headers.get(lang);
                    MimeMessage msg = new MimeMessage(this.mailSession);
                    HashSet<String> toAddresses = new HashSet<String>();
                    for (User user2 : (List)entry.getValue()) {
                        String emailAddress = userInfo.getEmailForEntity((OrganizationalEntity)user2);
                        if (emailAddress != null && !toAddresses.contains(emailAddress)) {
                            msg.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)emailAddress, (boolean)false));
                            toAddresses.add(emailAddress);
                            continue;
                        }
                        logger.warn("Email address not found for user {}", (Object)user2.getId());
                    }
                    if (header.getFrom() != null && header.getFrom().trim().length() > 0) {
                        user = TaskModelProvider.getFactory().newUser();
                        ((InternalOrganizationalEntity)user).setId(header.getFrom());
                        msg.setFrom((Address)new InternetAddress(userInfo.getEmailForEntity((OrganizationalEntity)user)));
                    } else {
                        msg.setFrom((Address)new InternetAddress(this.mailSession.getProperty("mail.from")));
                    }
                    if (header.getReplyTo() != null && header.getReplyTo().trim().length() > 0) {
                        user = TaskModelProvider.getFactory().newUser();
                        ((InternalOrganizationalEntity)user).setId(header.getReplyTo());
                        msg.setReplyTo((Address[])new InternetAddress[]{new InternetAddress(userInfo.getEmailForEntity((OrganizationalEntity)user))});
                    } else if (this.mailSession.getProperty("mail.replyto") != null) {
                        msg.setReplyTo((Address[])new InternetAddress[]{new InternetAddress(this.mailSession.getProperty("mail.replyto"))});
                    }
                    HashMap<String, Object> vars = new HashMap<String, Object>();
                    vars.put("doc", variables);
                    vars.put("processInstanceId", task.getTaskData().getProcessInstanceId());
                    vars.put("processSessionId", task.getTaskData().getProcessSessionId());
                    vars.put("workItemId", task.getTaskData().getWorkItemId());
                    vars.put("expirationTime", task.getTaskData().getExpirationTime());
                    vars.put("taskId", task.getId());
                    if (task.getPeopleAssignments() != null) {
                        vars.put("owners", task.getPeopleAssignments().getPotentialOwners());
                    }
                    String subject = (String)TemplateRuntime.eval((String)header.getSubject(), vars);
                    String body = (String)TemplateRuntime.eval((String)header.getBody(), vars);
                    if (variables.containsKey("attachments")) {
                        MimeMultipart multipart = new MimeMultipart();
                        MimeBodyPart messageBodyPart = new MimeBodyPart();
                        messageBodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(body, "text/html")));
                        multipart.addBodyPart((BodyPart)messageBodyPart);
                        List<String> attachments = this.getAttachements(variables.get("attachments"));
                        for (String attachment : attachments) {
                            MimeBodyPart attachementBodyPart = new MimeBodyPart();
                            URL attachmentUrl = this.getAttachemntURL(attachment);
                            String contentType = MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(attachmentUrl.getFile());
                            attachementBodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(attachmentUrl.openStream(), contentType)));
                            String fileName = new File(attachmentUrl.getFile()).getName();
                            attachementBodyPart.setFileName(fileName);
                            attachementBodyPart.setContentID("<" + fileName + ">");
                            multipart.addBodyPart((BodyPart)attachementBodyPart);
                        }
                        msg.setContent((Multipart)multipart);
                    } else {
                        msg.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(body, "text/html")));
                    }
                    msg.setSubject(subject);
                    msg.setHeader("X-Mailer", "jbpm human task service");
                    msg.setSentDate(new Date());
                    Transport.send((Message)msg);
                }
                catch (Exception e) {
                    logger.error("Unable to send email notification due to {}", (Object)e.getMessage());
                    logger.debug("Stacktrace:", (Throwable)e);
                }
            }
        }
    }

    protected URL getAttachemntURL(String attachment) throws MalformedURLException {
        if (attachment.startsWith("classpath:")) {
            String location = attachment.replaceFirst("classpath:", "");
            return this.getClass().getResource(location);
        }
        URL attachmentUrl = new URL(attachment);
        return attachmentUrl;
    }

    protected List<String> getAttachements(Object attachementsFromVariables) {
        if (attachementsFromVariables instanceof List) {
            return (List)attachementsFromVariables;
        }
        String attachementsAsString = attachementsFromVariables.toString();
        return Arrays.asList(attachementsAsString.split(","));
    }

    protected void buildMapByLanguage(Map<String, List<User>> map, Group group, UserInfo userInfo) {
        Iterator it = userInfo.getMembersForGroup(group);
        if (it != null) {
            while (it.hasNext()) {
                OrganizationalEntity entity = (OrganizationalEntity)it.next();
                if (entity instanceof Group) {
                    this.buildMapByLanguage(map, (Group)entity, userInfo);
                    continue;
                }
                this.buildMapByLanguage(map, (User)entity, userInfo);
            }
        }
    }

    protected void buildMapByLanguage(Map<String, List<User>> map, User user, UserInfo userInfo) {
        String language = userInfo.getLanguageForEntity((OrganizationalEntity)user);
        List<User> list = map.get(language);
        if (list == null) {
            list = new ArrayList<User>();
            map.put(language, list);
        }
        list.add(user);
    }
}

