/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.healthcheck;

import org.apache.helix.healthcheck.AggregationType;
import org.apache.log4j.Logger;

public class DecayAggregationType
implements AggregationType {
    private static final Logger logger = Logger.getLogger(DecayAggregationType.class);
    public static final String TYPE_NAME = "decay";
    double _decayFactor = 0.1;

    public DecayAggregationType(double df) {
        this._decayFactor = df;
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        sb.append(TYPE_NAME);
        sb.append("#");
        sb.append(this._decayFactor);
        return sb.toString();
    }

    @Override
    public String merge(String iv, String ev, long prevTimestamp) {
        double incomingVal = Double.parseDouble(iv);
        double existingVal = Double.parseDouble(ev);
        long currTimestamp = System.currentTimeMillis();
        double minutesOld = (double)(currTimestamp - prevTimestamp) / 60000.0;
        double oldDecayCoeff = Math.pow(1.0 - this._decayFactor, minutesOld);
        return String.valueOf(oldDecayCoeff * existingVal + (1.0 - oldDecayCoeff) * incomingVal);
    }
}

