/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.resourceLoader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.jboss.solder.logging.Logger;
import org.jboss.solder.resourceLoader.ResourceLoader;
import org.jboss.solder.resourceLoader.ResourceProducer;

class ClasspathResourceLoader
implements ResourceLoader {
    private static final Logger log = Logger.getLogger((String)"org.jboss.solder.resources");

    ClasspathResourceLoader() {
    }

    public InputStream getResourceAsStream(String name) {
        String strippedName = ClasspathResourceLoader.getStrippedName(name);
        if (Thread.currentThread().getContextClassLoader() != null) {
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(strippedName);
            if (stream != null) {
                log.trace((Object)("Loaded resource from context classloader: " + strippedName));
                return stream;
            }
        } else {
            InputStream stream = ResourceProducer.class.getResourceAsStream(strippedName);
            if (stream != null) {
                log.trace((Object)("Loaded resource from Solder classloader: " + strippedName));
                return stream;
            }
        }
        return null;
    }

    public URL getResource(String name) {
        String strippedName = ClasspathResourceLoader.getStrippedName(name);
        if (Thread.currentThread().getContextClassLoader() != null) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(strippedName);
            if (url != null) {
                log.trace((Object)("Loaded resource from context classloader: " + strippedName));
                return url;
            }
        } else {
            URL url = ResourceProducer.class.getResource(strippedName);
            if (url != null) {
                log.trace((Object)("Loaded resource from Solder classloader: " + strippedName));
                return url;
            }
        }
        return null;
    }

    public Set<URL> getResources(String name) {
        HashSet<URL> urls = new HashSet<URL>();
        String strippedName = ClasspathResourceLoader.getStrippedName(name);
        if (Thread.currentThread().getContextClassLoader() != null) {
            try {
                Enumeration<URL> urlEnum = Thread.currentThread().getContextClassLoader().getResources(strippedName);
                while (urlEnum.hasMoreElements()) {
                    urls.add(urlEnum.nextElement());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Enumeration<URL> urlEnum = ResourceProducer.class.getClassLoader().getResources(strippedName);
            while (urlEnum.hasMoreElements()) {
                urls.add(urlEnum.nextElement());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return urls;
    }

    public Collection<InputStream> getResourcesAsStream(String name) {
        HashSet<InputStream> resources = new HashSet<InputStream>();
        String strippedName = ClasspathResourceLoader.getStrippedName(name);
        if (Thread.currentThread().getContextClassLoader() != null) {
            try {
                Enumeration<URL> urlEnum = Thread.currentThread().getContextClassLoader().getResources(strippedName);
                while (urlEnum.hasMoreElements()) {
                    resources.add(urlEnum.nextElement().openStream());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Enumeration<URL> urlEnum = ResourceProducer.class.getClassLoader().getResources(strippedName);
            while (urlEnum.hasMoreElements()) {
                resources.add(urlEnum.nextElement().openStream());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return resources;
    }

    public int getPrecedence() {
        return 10;
    }

    private static String getStrippedName(String name) {
        return name.startsWith("/") ? name.substring(1) : name;
    }
}

