/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.containers;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.sonatype.guice.bean.binders.ParameterKeys;
import org.sonatype.guice.bean.binders.SpaceModule;
import org.sonatype.guice.bean.binders.WireModule;
import org.sonatype.guice.bean.locators.MutableBeanLocator;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.reflect.URLClassSpace;
import org.sonatype.inject.BeanScanning;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InjectedTest
implements Module {
    private String basedir;
    @Inject
    private MutableBeanLocator locator;

    @Before
    @BeforeMethod
    public void setUp() {
        Guice.createInjector((Module[])new Module[]{new WireModule(new Module[]{new SetUpModule(), new SpaceModule(this.space(), this.scanning())})});
    }

    @After
    @AfterMethod
    public void tearDown() {
        this.locator.clear();
    }

    public ClassSpace space() {
        return new URLClassSpace(this.getClass().getClassLoader());
    }

    public BeanScanning scanning() {
        return BeanScanning.CACHE;
    }

    public void configure(Binder binder) {
    }

    public void configure(Properties properties) {
    }

    public final <T> T lookup(Class<T> type) {
        return this.lookup(Key.get(type));
    }

    public final <T> T lookup(Class<T> type, String name) {
        return this.lookup(type, (Annotation)Names.named((String)name));
    }

    public final <T> T lookup(Class<T> type, Class<? extends Annotation> qualifier) {
        return this.lookup(Key.get(type, qualifier));
    }

    public final <T> T lookup(Class<T> type, Annotation qualifier) {
        return this.lookup(Key.get(type, (Annotation)qualifier));
    }

    public final String getBasedir() {
        if (null == this.basedir) {
            this.basedir = System.getProperty("basedir", new File("").getAbsolutePath());
        }
        return this.basedir;
    }

    private final <T> T lookup(Key<T> key) {
        Iterator i = this.locator.locate(key).iterator();
        return i.hasNext() ? (T)((Map.Entry)i.next()).getValue() : null;
    }

    final class SetUpModule
    extends AbstractModule {
        SetUpModule() {
        }

        protected void configure() {
            this.install(InjectedTest.this);
            Properties properties = new Properties();
            properties.put("basedir", InjectedTest.this.getBasedir());
            InjectedTest.this.configure(properties);
            this.bind(ParameterKeys.PROPERTIES).toInstance((Object)properties);
            this.requestInjection(InjectedTest.this);
        }
    }
}

