/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.beliefsystem.simple;

import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.BeliefSystem;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;

public class SimpleBeliefSet
extends LinkedList
implements BeliefSet {
    private BeliefSystem beliefSystem;
    private InternalFactHandle fh;
    private WorkingMemoryAction wmAction;

    public SimpleBeliefSet(BeliefSystem beliefSystem, InternalFactHandle fh) {
        this.beliefSystem = beliefSystem;
        this.fh = fh;
    }

    @Override
    public BeliefSystem getBeliefSystem() {
        return this.beliefSystem;
    }

    @Override
    public InternalFactHandle getFactHandle() {
        return this.fh;
    }

    @Override
    public void cancel(PropagationContext context) {
        LinkedListEntry entry = (LinkedListEntry)this.getFirst();
        while (entry != this.getLast()) {
            LinkedListEntry temp = (LinkedListEntry)entry.getNext();
            LogicalDependency node = (LogicalDependency)entry.getObject();
            node.getJustifier().getLogicalDependencies().remove(node);
            this.remove(entry);
            entry = temp;
        }
        LinkedListEntry last = (LinkedListEntry)this.getFirst();
        LogicalDependency node = (LogicalDependency)last.getObject();
        node.getJustifier().getLogicalDependencies().remove(node);
        this.beliefSystem.delete(node, this, context);
    }

    @Override
    public void clear(PropagationContext context) {
        LinkedListEntry entry = (LinkedListEntry)this.getFirst();
        while (entry != null) {
            LinkedListEntry temp = (LinkedListEntry)entry.getNext();
            LogicalDependency node = (LogicalDependency)entry.getObject();
            node.getJustifier().getLogicalDependencies().remove(node);
            this.remove(entry);
            entry = temp;
        }
    }

    public WorkingMemoryAction getWorkingMemoryAction() {
        return this.wmAction;
    }

    @Override
    public void setWorkingMemoryAction(WorkingMemoryAction wmAction) {
        this.wmAction = wmAction;
    }

    @Override
    public boolean isNegated() {
        return false;
    }

    @Override
    public boolean isUndecided() {
        return false;
    }

    @Override
    public boolean isPositive() {
        return !this.isEmpty();
    }
}

