/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleSets;
import org.drools.core.common.LeftTupleSetsImpl;
import org.drools.core.common.NetworkNode;
import org.drools.core.common.TimedRuleExecution;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.PersisterHelper;
import org.drools.core.marshalling.impl.ProtobufInputMarshaller;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.marshalling.impl.ProtobufOutputMarshaller;
import org.drools.core.marshalling.impl.TimersInputMarshaller;
import org.drools.core.marshalling.impl.TimersOutputMarshaller;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.phreak.StackEntry;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TimerNode;
import org.drools.core.spi.PropagationContext;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.time.impl.Timer;
import org.drools.core.util.LinkedList;
import org.drools.core.util.index.LeftTupleList;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.Calendars;
import org.kie.api.runtime.conf.TimedRuleExecutionFilter;
import org.kie.internal.concurrent.ExecutorProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhreakTimerNode {
    private static final Logger log = LoggerFactory.getLogger(PhreakTimerNode.class);

    public void doNode(TimerNode timerNode, TimerNode.TimerNodeMemory tm, PathMemory pmem, SegmentMemory smem, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(timerNode, tm, pmem, sink, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(timerNode, tm, pmem, smem, sink, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(timerNode, tm, pmem, smem, sink, wm, srcLeftTuples, trgLeftTuples);
        }
        PhreakTimerNode.doPropagateChildLeftTuples(timerNode, tm, sink, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(TimerNode timerNode, TimerNode.TimerNodeMemory tm, PathMemory pmem, SegmentMemory smem, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
        Timer timer = timerNode.getTimer();
        TimerService timerService = wm.getTimerService();
        long timestamp = timerService.getCurrentTime();
        String[] calendarNames = timerNode.getCalendarNames();
        Calendars calendars = wm.getCalendars();
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            this.scheduleLeftTuple(timerNode, tm, pmem, smem, sink, wm, timer, timerService, timestamp, calendarNames, calendars, leftTuple, trgLeftTuples, null);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLeftUpdates(TimerNode timerNode, TimerNode.TimerNodeMemory tm, PathMemory pmem, SegmentMemory smem, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        Timer timer = timerNode.getTimer();
        TimerService timerService = wm.getTimerService();
        long timestamp = timerService.getCurrentTime();
        String[] calendarNames = timerNode.getCalendarNames();
        Calendars calendars = wm.getCalendars();
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            LeftTupleList leftTuples = tm.getInsertOrUpdateLeftTuples();
            DefaultJobHandle jobHandle = (DefaultJobHandle)leftTuple.getObject();
            if (jobHandle != null) {
                LeftTupleList leftTupleList = leftTuples;
                synchronized (leftTupleList) {
                    timerService.removeJob(jobHandle);
                }
            }
            this.scheduleLeftTuple(timerNode, tm, pmem, smem, sink, wm, timer, timerService, timestamp, calendarNames, calendars, leftTuple, trgLeftTuples, stagedLeftTuples);
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLeftDeletes(TimerNode timerNode, TimerNode.TimerNodeMemory tm, PathMemory pmem, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        LeftTupleList leftTuples;
        TimerService timerService = wm.getTimerService();
        LeftTupleList leftTupleList = leftTuples = tm.getInsertOrUpdateLeftTuples();
        synchronized (leftTupleList) {
            LeftTuple next;
            LeftTuple leftTuple;
            LeftTupleList deletes = tm.getDeleteLeftTuples();
            if (!deletes.isEmpty()) {
                leftTuple = deletes.getFirst();
                while (leftTuple != null) {
                    next = (LeftTuple)leftTuple.getNext();
                    srcLeftTuples.addDelete(leftTuple);
                    if (log.isTraceEnabled()) {
                        log.trace("Timer Add Postponed Delete {}", (Object)leftTuple);
                    }
                    leftTuple.clear();
                    leftTuple = next;
                }
                deletes.clear();
            }
            leftTuple = srcLeftTuples.getDeleteFirst();
            while (leftTuple != null) {
                LeftTuple childLeftTuple;
                next = leftTuple.getStagedNext();
                DefaultJobHandle jobHandle = (DefaultJobHandle)leftTuple.getObject();
                if (jobHandle != null) {
                    timerService.removeJob(jobHandle);
                }
                PropagationContext pctx = leftTuple.getPropagationContext();
                pctx = RuleTerminalNode.findMostRecentPropagationContext(leftTuple, pctx);
                if (leftTuple.getMemory() != null) {
                    leftTuples.remove(leftTuple);
                    if (pctx.getType() == 5) {
                        PhreakTimerNode.doPropagateChildLeftTuple(sink, trgLeftTuples, stagedLeftTuples, leftTuple, tm);
                        tm.getDeleteLeftTuples().add(leftTuple);
                        pmem.doLinkRule(wm);
                        if (log.isTraceEnabled()) {
                            log.trace("Timer Postponed Delete {}", (Object)leftTuple);
                        }
                    }
                }
                if (leftTuple.getMemory() == null && (childLeftTuple = leftTuple.getFirstChild()) != null) {
                    switch (childLeftTuple.getStagedType()) {
                        case 1: {
                            stagedLeftTuples.removeInsert(childLeftTuple);
                            break;
                        }
                        case 2: {
                            stagedLeftTuples.removeUpdate(childLeftTuple);
                        }
                    }
                    childLeftTuple.setPropagationContext(leftTuple.getPropagationContext());
                    trgLeftTuples.addDelete(childLeftTuple);
                    if (log.isTraceEnabled()) {
                        log.trace("Timer Delete {}", (Object)leftTuple);
                    }
                }
                leftTuple.clearStaged();
                leftTuple = next;
            }
        }
    }

    private void scheduleLeftTuple(final TimerNode timerNode, final TimerNode.TimerNodeMemory tm, final PathMemory pmem, final SegmentMemory smem, final LeftTupleSink sink, final InternalWorkingMemory wm, final Timer timer, final TimerService timerService, final long timestamp, final String[] calendarNames, final Calendars calendars, final LeftTuple leftTuple, final LeftTupleSets trgLeftTuples, final LeftTupleSets stagedLeftTuples) {
        if (leftTuple.getPropagationContext().getReaderContext() == null) {
            Trigger trigger = this.createTrigger(timerNode, wm, timer, timestamp, calendarNames, calendars, leftTuple);
            this.scheduleTimer(timerNode, tm, pmem, smem, sink, wm, timerService, timestamp, leftTuple, trgLeftTuples, stagedLeftTuples, trigger);
        } else {
            Scheduler scheduler = new Scheduler(){

                @Override
                public void schedule(Trigger t) {
                    PhreakTimerNode.this.scheduleTimer(timerNode, tm, pmem, smem, sink, wm, timerService, timestamp, leftTuple, trgLeftTuples, stagedLeftTuples, t);
                }

                @Override
                public Trigger getTrigger() {
                    return PhreakTimerNode.this.createTrigger(timerNode, wm, timer, timestamp, calendarNames, calendars, leftTuple);
                }
            };
            leftTuple.getPropagationContext().getReaderContext().addTimerNodeScheduler(timerNode.getId(), PersisterHelper.createTupleKey(leftTuple), scheduler);
        }
    }

    private Trigger createTrigger(TimerNode timerNode, InternalWorkingMemory wm, Timer timer, long timestamp, String[] calendarNames, Calendars calendars, LeftTuple leftTuple) {
        DefaultJobHandle jobHandle = (DefaultJobHandle)leftTuple.getObject();
        Trigger trigger = timer.createTrigger(timestamp, leftTuple, jobHandle, calendarNames, calendars, timerNode.getDeclarations(), wm);
        return trigger;
    }

    private void scheduleTimer(TimerNode timerNode, TimerNode.TimerNodeMemory tm, PathMemory pmem, SegmentMemory smem, LeftTupleSink sink, InternalWorkingMemory wm, TimerService timerService, long timestamp, LeftTuple leftTuple, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples, Trigger trigger) {
        if (trigger.hasNextFireTime() == null) {
            return;
        }
        if (trigger.hasNextFireTime().getTime() <= timestamp) {
            LeftTuple childLeftTuple;
            if (log.isTraceEnabled()) {
                log.trace("Timer Fire Now {}", (Object)leftTuple);
            }
            if ((childLeftTuple = PhreakTimerNode.doPropagateChildLeftTuple(sink, trgLeftTuples, stagedLeftTuples, leftTuple, tm)).getStagedType() != 0) {
                childLeftTuple.setObject(Boolean.TRUE);
            }
            trigger.nextFireTime();
            Date nextFireTime = trigger.hasNextFireTime();
            if (nextFireTime != null && nextFireTime.getTime() <= timestamp) {
                throw new IllegalStateException("Trigger.nextFireTime is not increasing");
            }
        }
        if (trigger.hasNextFireTime() != null) {
            TimerNodeJob job = new TimerNodeJob();
            TimerNodeJobContext jobCtx = new TimerNodeJobContext(timerNode.getId(), trigger, leftTuple, tm, sink, smem.getPathMemories(), wm);
            DefaultJobHandle jobHandle = (DefaultJobHandle)timerService.scheduleJob(job, jobCtx, trigger);
            leftTuple.setObject(jobHandle);
            if (log.isTraceEnabled()) {
                log.trace("Timer Scheduled {}", (Object)leftTuple);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doPropagateChildLeftTuples(TimerNode timerNode, TimerNode.TimerNodeMemory tm, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        LeftTupleList leftTuples;
        LeftTupleList leftTupleList = leftTuples = tm.getInsertOrUpdateLeftTuples();
        synchronized (leftTupleList) {
            LeftTuple leftTuple = leftTuples.getFirst();
            while (leftTuple != null) {
                LeftTuple next = (LeftTuple)leftTuple.getNext();
                PhreakTimerNode.doPropagateChildLeftTuple(sink, trgLeftTuples, stagedLeftTuples, leftTuple, tm);
                leftTuple.clear();
                leftTuple = next;
            }
            if (tm.getDeleteLeftTuples().isEmpty()) {
                tm.setNodeCleanWithoutNotify();
            }
            leftTuples.clear();
        }
    }

    private static LeftTuple doPropagateChildLeftTuple(LeftTupleSink sink, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples, LeftTuple leftTuple, TimerNode.TimerNodeMemory tm) {
        LeftTuple childLeftTuple = leftTuple.getFirstChild();
        if (childLeftTuple == null) {
            childLeftTuple = sink.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), true);
            trgLeftTuples.addInsert(childLeftTuple);
            if (log.isTraceEnabled()) {
                log.trace("Timer Insert {}", (Object)childLeftTuple);
            }
        } else if (childLeftTuple.getObject() == Boolean.TRUE) {
            childLeftTuple.setObject(null);
        } else {
            switch (childLeftTuple.getStagedType()) {
                case 1: {
                    stagedLeftTuples.removeInsert(childLeftTuple);
                    break;
                }
                case 2: {
                    stagedLeftTuples.removeUpdate(childLeftTuple);
                }
            }
            trgLeftTuples.addUpdate(childLeftTuple);
            if (log.isTraceEnabled()) {
                log.trace("Timer Update {}", (Object)childLeftTuple);
            }
        }
        return childLeftTuple;
    }

    public static class TimerNodeTimerInputMarshaller
    implements TimersInputMarshaller {
        public void read(MarshallerReaderContext inCtx) throws IOException, ClassNotFoundException {
            throw new UnsupportedOperationException("This method should no longer be used and is due to removal.");
        }

        @Override
        public void deserialize(MarshallerReaderContext inCtx, ProtobufMessages.Timers.Timer _timer) throws ClassNotFoundException {
            ProtobufMessages.Timers.TimerNodeTimer _tn = _timer.getTimerNode();
            int timerNodeId = _tn.getNodeId();
            ProtobufInputMarshaller.TupleKey tuple = PersisterHelper.createTupleKey(_tn.getTuple());
            Trigger trigger = ProtobufInputMarshaller.readTrigger(inCtx, _tn.getTrigger());
            Scheduler scheduler = inCtx.removeTimerNodeScheduler(timerNodeId, tuple);
            if (scheduler != null) {
                scheduler.schedule(trigger);
            }
        }
    }

    public static class TimerNodeTimerOutputMarshaller
    implements TimersOutputMarshaller {
        public void write(JobContext jobCtx, MarshallerWriteContext outputCtx) throws IOException {
            throw new UnsupportedOperationException("This method should no longer be used and is due to removal.");
        }

        @Override
        public ProtobufMessages.Timers.Timer serialize(JobContext jobCtx, MarshallerWriteContext outputCtx) {
            TimerNodeJobContext tnJobCtx = (TimerNodeJobContext)jobCtx;
            return ProtobufMessages.Timers.Timer.newBuilder().setType(ProtobufMessages.Timers.TimerType.TIMER_NODE).setTimerNode(ProtobufMessages.Timers.TimerNodeTimer.newBuilder().setNodeId(tnJobCtx.getTimerNodeId()).setTuple(PersisterHelper.createTuple(tnJobCtx.getLeftTuple())).setTrigger(ProtobufOutputMarshaller.writeTrigger(tnJobCtx.getTrigger(), outputCtx)).build()).build();
        }
    }

    public static class TimerNodeJobContext
    implements JobContext {
        private JobHandle jobHandle;
        private final Trigger trigger;
        private final LeftTuple leftTuple;
        private final int timerNodeId;
        private final TimerNode.TimerNodeMemory tm;
        private final LeftTupleSink sink;
        private final List<PathMemory> pmems;
        private final InternalWorkingMemory wm;

        public TimerNodeJobContext(int timerNodeId, Trigger trigger, LeftTuple leftTuple, TimerNode.TimerNodeMemory tm, LeftTupleSink sink, List<PathMemory> pmems, InternalWorkingMemory wm) {
            this.timerNodeId = timerNodeId;
            this.trigger = trigger;
            this.leftTuple = leftTuple;
            this.sink = sink;
            this.pmems = pmems;
            this.tm = tm;
            this.wm = wm;
        }

        @Override
        public JobHandle getJobHandle() {
            return this.jobHandle;
        }

        @Override
        public void setJobHandle(JobHandle jobHandle) {
            this.jobHandle = jobHandle;
        }

        public LeftTupleSink getSink() {
            return this.sink;
        }

        public LeftTuple getLeftTuple() {
            return this.leftTuple;
        }

        public TimerNode.TimerNodeMemory getTimerNodeMemory() {
            return this.tm;
        }

        public List<PathMemory> getPathMemories() {
            return this.pmems;
        }

        public InternalWorkingMemory getWorkingMemory() {
            return this.wm;
        }

        public Trigger getTrigger() {
            return this.trigger;
        }

        public int getTimerNodeId() {
            return this.timerNodeId;
        }
    }

    public static class Executor
    implements TimedRuleExecution {
        private final PathMemory pmem;
        private final InternalWorkingMemory wm;
        private final LeftTupleSink sink;
        private final TimerNode.TimerNodeMemory tm;

        public Executor(PathMemory pmem, InternalWorkingMemory wm, LeftTupleSink sink, TimerNode.TimerNodeMemory tm) {
            this.pmem = pmem;
            this.wm = wm;
            this.sink = sink;
            this.tm = tm;
        }

        @Override
        public void evauateAndFireRule() {
            SegmentMemory[] smems = this.pmem.getSegmentMemories();
            LeftInputAdapterNode lian = (LeftInputAdapterNode)smems[0].getRootNode();
            SegmentMemory sm = this.tm.getSegmentMemory();
            int smemIndex = 0;
            for (SegmentMemory smem : smems) {
                if (smem == sm) break;
                ++smemIndex;
            }
            long bit = 1L;
            NetworkNode node = sm.getRootNode();
            while (node != this.sink) {
                bit <<= 1;
                node = ((LeftTupleSource)node).getSinkPropagator().getFirstLeftTupleSink();
            }
            LeftTupleSetsImpl trgLeftTuples = new LeftTupleSetsImpl();
            PhreakTimerNode.doPropagateChildLeftTuples(null, this.tm, this.sink, this.wm, null, trgLeftTuples, sm.getStagedLeftTuples());
            RuleNetworkEvaluator rne = new RuleNetworkEvaluator();
            LinkedList<StackEntry> outerStack = new LinkedList<StackEntry>();
            rne.outerEval(lian, this.pmem, this.sink, bit, this.tm, smems, smemIndex, trgLeftTuples, this.wm, new LinkedList<StackEntry>(), outerStack, new HashSet<String>(), true, this.pmem.getRuleAgendaItem().getRuleExecutor());
            this.pmem.getRuleAgendaItem().getRuleExecutor().fire(this.wm, outerStack);
        }
    }

    private static class ExecutorHolder {
        private static final java.util.concurrent.Executor executor = ExecutorProviderFactory.getExecutorProvider().newSingleThreadExecutor();

        private ExecutorHolder() {
        }
    }

    public static class TimerNodeJob
    implements Job {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(JobContext ctx) {
            final TimerNodeJobContext timerJobCtx = (TimerNodeJobContext)ctx;
            Trigger trigger = timerJobCtx.getTrigger();
            LeftTupleList leftTuples = timerJobCtx.getTimerNodeMemory().getInsertOrUpdateLeftTuples();
            LeftTuple lt = timerJobCtx.getLeftTuple();
            if (log.isTraceEnabled()) {
                log.trace("Timer Executor {} {}", (Object)timerJobCtx.getTrigger(), (Object)lt);
            }
            LeftTupleList leftTupleList = leftTuples;
            synchronized (leftTupleList) {
                if (timerJobCtx.getJobHandle().isCancel()) {
                    return;
                }
                if (lt.getMemory() == null) {
                    leftTuples.add(lt);
                }
            }
            timerJobCtx.getTimerNodeMemory().setNodeDirtyWithoutNotify();
            for (final PathMemory pmem : timerJobCtx.getPathMemories()) {
                pmem.doLinkRule(timerJobCtx.getWorkingMemory());
                pmem.queueRuleAgendaItem(timerJobCtx.getWorkingMemory());
                final TimedRuleExecutionFilter filter = timerJobCtx.getWorkingMemory().getSessionConfiguration().getTimedRuleExecutionFilter();
                if (filter == null) continue;
                ExecutorHolder.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (filter.accept(new Rule[]{pmem.getRule()})) {
                            new Executor(pmem, timerJobCtx.getWorkingMemory(), timerJobCtx.getSink(), timerJobCtx.getTimerNodeMemory()).evauateAndFireRule();
                        }
                    }
                });
            }
        }
    }

    public static interface Scheduler {
        public void schedule(Trigger var1);

        public Trigger getTrigger();
    }
}

