/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.properties;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import org.jboss.solder.properties.FieldProperty;
import org.jboss.solder.reflection.Reflections;

class FieldPropertyImpl<V>
implements FieldProperty<V> {
    private final Field field;

    FieldPropertyImpl(Field field) {
        this.field = field;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public Type getBaseType() {
        return this.field.getGenericType();
    }

    @Override
    public Field getAnnotatedElement() {
        return this.field;
    }

    @Override
    public Member getMember() {
        return this.field;
    }

    @Override
    public Class<V> getJavaClass() {
        return this.field.getType();
    }

    @Override
    public V getValue(Object instance) {
        this.setAccessible();
        return (V)Reflections.getFieldValue((Field)this.field, (Object)instance, this.getJavaClass());
    }

    @Override
    public void setValue(Object instance, V value) {
        this.setAccessible();
        Reflections.setFieldValue((boolean)true, (Field)this.field, (Object)instance, value);
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void setAccessible() {
        Reflections.setAccessible((AccessibleObject)this.field);
    }

    public String toString() {
        return this.field.toString();
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    public boolean equals(Object obj) {
        return this.field.equals(obj);
    }
}

