/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.Asynchronous;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.inject.Inject;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jbpm.executor.entities.ErrorInfo;
import org.jbpm.executor.entities.RequestInfo;
import org.jbpm.executor.impl.ClassCacheManager;
import org.kie.internal.executor.api.Command;
import org.kie.internal.executor.api.CommandCallback;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.executor.api.ExecutionResults;
import org.kie.internal.executor.api.ExecutorQueryService;
import org.kie.internal.executor.api.ExecutorStoreService;
import org.kie.internal.executor.api.STATUS;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.RuntimeManagerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@TransactionManagement(value=TransactionManagementType.BEAN)
public class AvailableJobsExecutor {
    private static final Logger logger = LoggerFactory.getLogger(AvailableJobsExecutor.class);
    private Map<String, Object> contextData = new HashMap<String, Object>();
    @Inject
    private ExecutorQueryService queryService;
    @Inject
    private ClassCacheManager classCacheManager;
    @Inject
    private ExecutorStoreService executorStoreService;

    public void setQueryService(ExecutorQueryService queryService) {
        this.queryService = queryService;
    }

    public void setClassCacheManager(ClassCacheManager classCacheManager) {
        this.classCacheManager = classCacheManager;
    }

    public void setExecutorStoreService(ExecutorStoreService executorStoreService) {
        this.executorStoreService = executorStoreService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Asynchronous
    public void executeJob() {
        block21: {
            logger.debug("Executor Thread {} Waking Up!!!", (Object)this.toString());
            try {
                RequestInfo request = (RequestInfo)this.queryService.getRequestForProcessing();
                if (request == null) break block21;
                CommandContext ctx = null;
                List<CommandCallback> callbacks = null;
                ClassLoader cl = this.getClassLoader(request.getDeploymentId());
                try {
                    logger.debug("Processing Request Id: {}, status {} command {}", new Object[]{request.getId(), request.getStatus(), request.getCommandName()});
                    byte[] reqData = request.getRequestData();
                    if (reqData != null) {
                        ObjectInputStream in = null;
                        try {
                            in = new ClassLoaderObjectInputStream(cl, (InputStream)new ByteArrayInputStream(reqData));
                            ctx = (CommandContext)in.readObject();
                        }
                        catch (IOException e) {
                            logger.warn("Exception while serializing context data", (Throwable)e);
                            return;
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    for (Map.Entry<String, Object> entry : this.contextData.entrySet()) {
                        ctx.setData(entry.getKey(), entry.getValue());
                    }
                    ctx.setData("ClassLoader", (Object)cl);
                    Command cmd = this.classCacheManager.findCommand(request.getCommandName(), cl);
                    ExecutionResults results = cmd.execute(ctx);
                    callbacks = this.classCacheManager.buildCommandCallback(ctx, cl);
                    for (CommandCallback handler : callbacks) {
                        handler.onCommandDone(ctx, results);
                    }
                    if (results != null) {
                        try {
                            ByteArrayOutputStream bout = new ByteArrayOutputStream();
                            ObjectOutputStream out = new ObjectOutputStream(bout);
                            out.writeObject(results);
                            byte[] respData = bout.toByteArray();
                            request.setResponseData(respData);
                        }
                        catch (IOException e) {
                            request.setResponseData(null);
                        }
                    }
                    request.setStatus(STATUS.DONE);
                    this.executorStoreService.updateRequest((org.kie.internal.executor.api.RequestInfo)request);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable e) {
                    callbacks = this.classCacheManager.buildCommandCallback(ctx, cl);
                    logger.warn("Error during command {} execution {}", (Object)request.getCommandName(), (Object)e.getMessage());
                    ErrorInfo errorInfo = new ErrorInfo(e.getMessage(), ExceptionUtils.getFullStackTrace((Throwable)e.fillInStackTrace()));
                    errorInfo.setRequestInfo(request);
                    request.getErrorInfo().add(errorInfo);
                    logger.debug("Error Number: {}", (Object)request.getErrorInfo().size());
                    if (request.getRetries() > 0) {
                        request.setStatus(STATUS.RETRYING);
                        request.setRetries(request.getRetries() - 1);
                        request.setExecutions(request.getExecutions() + 1);
                        logger.debug("Retrying ({}) still available!", (Object)request.getRetries());
                        this.executorStoreService.updateRequest((org.kie.internal.executor.api.RequestInfo)request);
                    } else {
                        logger.debug("Error no retries left!");
                        request.setStatus(STATUS.ERROR);
                        request.setExecutions(request.getExecutions() + 1);
                        this.executorStoreService.updateRequest((org.kie.internal.executor.api.RequestInfo)request);
                        if (callbacks != null) {
                            for (CommandCallback handler : callbacks) {
                                handler.onCommandError(ctx, e);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Unexpected error while processin executor's job {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    protected ClassLoader getClassLoader(String deploymentId) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (deploymentId == null) {
            return cl;
        }
        InternalRuntimeManager manager = (InternalRuntimeManager)RuntimeManagerRegistry.get().getManager(deploymentId);
        if (manager != null && manager.getEnvironment().getClassLoader() != null) {
            cl = manager.getEnvironment().getClassLoader();
        }
        return cl;
    }

    public void addContextData(String name, Object data) {
        this.contextData.put(name, data);
    }
}

