/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class UpgradableReentrantReadWriteLock {
    private final boolean shouldTryAtomicUpgrade;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ThreadLocal<int[]> lockCounters = new ThreadLocal<int[]>(){

        @Override
        protected int[] initialValue() {
            return new int[]{0, 0};
        }
    };
    private AtomicBoolean tryingLockUpgrade = new AtomicBoolean(false);
    private final Integer lowPriotityMonitor = 42;
    private final Integer highPriorityMonitor = 43;

    public UpgradableReentrantReadWriteLock() {
        this(false);
    }

    public UpgradableReentrantReadWriteLock(boolean shouldTryAtomicUpgrade) {
        this.shouldTryAtomicUpgrade = shouldTryAtomicUpgrade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readLock() {
        int[] lockCounter = this.lockCounters.get();
        if (this.increaseUpgradedReadCounter(lockCounter)) {
            return;
        }
        if (this.shouldTryAtomicUpgrade && this.tryingLockUpgrade.get() && lockCounter[0] == 0) {
            try {
                Integer n = this.lowPriotityMonitor;
                synchronized (n) {
                    this.lowPriotityMonitor.wait();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.lock.readLock().lock();
        this.increaseReadCounter(lockCounter);
    }

    public void readUnlock() {
        int[] lockCounter = this.lockCounters.get();
        if (this.decreaseUpgradedReadCounter(lockCounter)) {
            return;
        }
        this.lock.readLock().unlock();
        this.decreaseReadCounters(lockCounter);
        this.notifyUpgradingThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyUpgradingThread() {
        if (this.shouldTryAtomicUpgrade && this.tryingLockUpgrade.get()) {
            Integer n = this.highPriorityMonitor;
            synchronized (n) {
                if (this.lock.getReadLockCount() < 2 && !this.lock.isWriteLocked()) {
                    this.highPriorityMonitor.notifyAll();
                }
            }
        }
    }

    public void writeLock() {
        if (this.lock.isWriteLockedByCurrentThread()) {
            this.lock.writeLock().lock();
            return;
        }
        int[] lockCounter = this.lockCounters.get();
        if (lockCounter[0] > 0) {
            lockCounter[1] = lockCounter[0];
            if (this.shouldTryAtomicUpgrade && this.tryingLockUpgrade.compareAndSet(false, true)) {
                this.atomicLockUpgrade(lockCounter[0]);
            } else {
                for (int i = lockCounter[0]; i > 0; --i) {
                    this.lock.readLock().unlock();
                }
                this.notifyUpgradingThread();
                this.lowPriorityWriteLock();
            }
        } else {
            this.lowPriorityWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lowPriorityWriteLock() {
        if (this.shouldTryAtomicUpgrade && this.tryingLockUpgrade.get()) {
            Integer n = this.lowPriotityMonitor;
            synchronized (n) {
                try {
                    this.lowPriotityMonitor.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.lock.writeLock().lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void atomicLockUpgrade(int readHoldCount) {
        for (int i = readHoldCount; i > 1; --i) {
            this.lock.readLock().unlock();
        }
        Integer n = this.highPriorityMonitor;
        synchronized (n) {
            if (this.lock.getReadLockCount() > readHoldCount || this.lock.isWriteLocked()) {
                try {
                    this.highPriorityMonitor.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.lock.readLock().unlock();
        this.lock.writeLock().lock();
        this.tryingLockUpgrade.set(false);
        n = this.lowPriotityMonitor;
        synchronized (n) {
            this.lowPriotityMonitor.notifyAll();
        }
    }

    public void writeUnlock() {
        int[] lockCounter;
        if (this.lock.getWriteHoldCount() == 1 && (lockCounter = this.lockCounters.get())[1] > 0) {
            for (int i = lockCounter[1]; i > 0; --i) {
                this.lock.readLock().lock();
            }
            lockCounter[1] = 0;
        }
        this.lock.writeLock().unlock();
        this.notifyUpgradingThread();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.lock.isWriteLockedByCurrentThread();
    }

    public int getWriteHoldCount() {
        return this.lock.getWriteHoldCount();
    }

    private void increaseReadCounter(int[] lockCounter) {
        lockCounter[0] = lockCounter[0] + 1;
    }

    private boolean increaseUpgradedReadCounter(int[] lockCounter) {
        if (lockCounter[1] == 0) {
            return false;
        }
        lockCounter[1] = lockCounter[1] + 1;
        return true;
    }

    private void decreaseReadCounters(int[] lockCounter) {
        lockCounter[0] = lockCounter[0] - 1;
    }

    private boolean decreaseUpgradedReadCounter(int[] lockCounter) {
        if (lockCounter[1] == 0) {
            return false;
        }
        lockCounter[1] = lockCounter[1] - 1;
        return true;
    }
}

