/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.client.api;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.remote.client.api.RemoteJmsRuntimeEngineBuilder;
import org.kie.remote.client.api.RemoteRestRuntimeEngineBuilder;
import org.kie.remote.client.api.exception.RemoteCommunicationException;

public abstract class RemoteRuntimeEngineFactory {
    public static RemoteJmsRuntimeEngineBuilder newJmsBuilder() {
        return org.kie.services.client.api.RemoteRuntimeEngineFactory.newJmsBuilder();
    }

    public static RemoteRestRuntimeEngineBuilder newRestBuilder() {
        return org.kie.services.client.api.RemoteRuntimeEngineFactory.newRestBuilder();
    }

    public abstract RuntimeEngine newRuntimeEngine();

    public static InitialContext getRemoteJbossInitialContext(String jbossServerHostName, String user, String password) {
        Properties initialProps = new Properties();
        initialProps.setProperty("java.naming.factory.initial", "org.jboss.naming.remote.client.InitialContextFactory");
        initialProps.setProperty("java.naming.provider.url", "remote://" + jbossServerHostName + ":4447");
        initialProps.setProperty("java.naming.security.principal", user);
        initialProps.setProperty("java.naming.security.credentials", password);
        for (Object keyObj : initialProps.keySet()) {
            String key = (String)keyObj;
            System.setProperty(key, (String)initialProps.get(key));
        }
        try {
            return new InitialContext(initialProps);
        }
        catch (NamingException e) {
            throw new RemoteCommunicationException("Unable to create " + InitialContext.class.getSimpleName(), e);
        }
    }
}

