/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.RuntimeEngineImpl;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.jbpm.runtime.manager.impl.SynchronizedRuntimeImpl;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.internal.runtime.manager.Disposable;
import org.kie.internal.runtime.manager.SessionFactory;
import org.kie.internal.runtime.manager.TaskServiceFactory;
import org.kie.internal.task.api.InternalTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonRuntimeManager
extends AbstractRuntimeManager {
    private static final Logger logger = LoggerFactory.getLogger(SingletonRuntimeManager.class);
    private RuntimeEngine singleton;
    private SessionFactory factory;
    private TaskServiceFactory taskServiceFactory;

    public SingletonRuntimeManager() {
        super(null, null);
    }

    public SingletonRuntimeManager(RuntimeEnvironment environment, SessionFactory factory, TaskServiceFactory taskServiceFactory, String identifier) {
        super(environment, identifier);
        this.factory = factory;
        this.taskServiceFactory = taskServiceFactory;
        this.identifier = identifier;
    }

    @Override
    public void init() {
        if (System.getProperty("org.kie.tx.lock.enabled") == null && ((SimpleRuntimeEnvironment)this.environment).getEnvironmentTemplate().get("TRANSACTION_LOCK_ENABLED") == null) {
            ((SimpleRuntimeEnvironment)this.environment).getEnvironmentTemplate().set("TRANSACTION_LOCK_ENABLED", (Object)"true");
        }
        String location = this.getLocation();
        Long knownSessionId = this.getPersistedSessionId(location, this.identifier);
        InternalTaskService internalTaskService = (InternalTaskService)this.taskServiceFactory.newTaskService();
        if (knownSessionId > 0L) {
            try {
                this.singleton = new SynchronizedRuntimeImpl(this.factory.findKieSessionById(knownSessionId), internalTaskService);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        if (this.singleton == null) {
            this.singleton = new SynchronizedRuntimeImpl(this.factory.newKieSession(), internalTaskService);
            this.persistSessionId(location, this.identifier, this.singleton.getKieSession().getIdentifier());
        }
        ((RuntimeEngineImpl)this.singleton).setManager((RuntimeManager)this);
        this.configureRuntimeOnTaskService(internalTaskService, this.singleton);
        this.registerItems(this.singleton);
        this.attachManager(this.singleton);
        this.registry.register((RuntimeManager)this);
    }

    public RuntimeEngine getRuntimeEngine(Context context) {
        if (this.isClosed()) {
            throw new IllegalStateException("Runtime manager " + this.identifier + " is already closed");
        }
        this.checkPermission();
        return this.singleton;
    }

    public void validate(KieSession ksession, Context<?> context) throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Runtime manager " + this.identifier + " is already closed");
        }
        if (this.singleton != null && this.singleton.getKieSession().getIdentifier() != ksession.getIdentifier()) {
            throw new IllegalStateException("Invalid session was used for this context " + context);
        }
    }

    public void disposeRuntimeEngine(RuntimeEngine runtime) {
    }

    @Override
    public void close() {
        if (this.singleton == null) {
            return;
        }
        super.close();
        try {
            this.removeRuntimeFromTaskService((InternalTaskService)this.singleton.getTaskService());
        }
        catch (UnsupportedOperationException e) {
            logger.debug("Exception while closing task service, was it initialized? {}", (Object)e.getMessage());
        }
        if (this.singleton instanceof Disposable) {
            ((Disposable)this.singleton).dispose();
        }
        this.factory.close();
        this.singleton = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getPersistedSessionId(String location, String identifier) {
        File sessionIdStore = new File(location + File.separator + identifier + "-jbpmSessionId.ser");
        if (sessionIdStore.exists()) {
            Long knownSessionId = null;
            FileInputStream fis = null;
            ObjectInputStream in = null;
            try {
                fis = new FileInputStream(sessionIdStore);
                in = new ObjectInputStream(fis);
                Object tmp = in.readObject();
                if (tmp instanceof Integer) {
                    tmp = new Long(((Integer)tmp).intValue());
                }
                knownSessionId = (Long)tmp;
                Long l = (long)knownSessionId;
                return l;
            }
            catch (Exception e) {
                Long l = 0L;
                return l;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistSessionId(String location, String identifier, Long ksessionId) {
        if (location == null) {
            return;
        }
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream(location + File.separator + identifier + "-jbpmSessionId.ser");
            out = new ObjectOutputStream(fos);
            out.writeObject((long)ksessionId);
            out.close();
        }
        catch (IOException ex) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected String getLocation() {
        String location = System.getProperty("jbpm.data.dir", System.getProperty("jboss.server.data.dir"));
        if (location == null) {
            location = System.getProperty("java.io.tmpdir");
        }
        return location;
    }

    public SessionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(SessionFactory factory) {
        this.factory = factory;
    }

    public TaskServiceFactory getTaskServiceFactory() {
        return this.taskServiceFactory;
    }

    public void setTaskServiceFactory(TaskServiceFactory taskServiceFactory) {
        this.taskServiceFactory = taskServiceFactory;
    }
}

