/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.document.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.drools.core.common.DroolsObjectInputStream;
import org.jbpm.document.Document;
import org.jbpm.document.service.DocumentStorageService;
import org.jbpm.document.service.impl.DocumentStorageServiceImpl;
import org.kie.api.marshalling.ObjectMarshallingStrategy;

public class DocumentMarshallingStrategy
implements ObjectMarshallingStrategy {
    private DocumentStorageService documentStorageService = new DocumentStorageServiceImpl();

    public boolean accept(Object o) {
        return o instanceof Document;
    }

    public void write(ObjectOutputStream os, Object object) throws IOException {
        Document document = (Document)object;
        if (document != null && document.getContent() != null) {
            this.documentStorageService.saveDocument(document, document.getContent());
        }
        os.writeUTF(document.getIdentifier());
        os.writeUTF(document.getClass().getCanonicalName());
        os.writeUTF(document.getLink());
    }

    public Object read(ObjectInputStream os) throws IOException, ClassNotFoundException {
        String objectId = os.readUTF();
        String canonicalName = os.readUTF();
        String link = os.readUTF();
        try {
            Document doc = this.documentStorageService.getDocument(objectId);
            Document document = (Document)Class.forName(canonicalName).newInstance();
            document.setIdentifier(objectId);
            document.setLink(link);
            document.setName(doc.getName());
            document.setSize(doc.getSize());
            document.setLastModified(doc.getLastModified());
            document.setAttributes(doc.getAttributes());
            document.setContent(doc.getContent());
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot read document", e);
        }
    }

    public byte[] marshal(ObjectMarshallingStrategy.Context context, ObjectOutputStream objectOutputStream, Object o) throws IOException {
        Document document = (Document)o;
        this.documentStorageService.saveDocument(document, document.getContent());
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(buff);
        oos.writeUTF(document.getIdentifier());
        oos.writeUTF(document.getClass().getCanonicalName());
        oos.writeUTF(document.getLink());
        oos.close();
        return buff.toByteArray();
    }

    public Object unmarshal(ObjectMarshallingStrategy.Context context, ObjectInputStream objectInputStream, byte[] object, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        DroolsObjectInputStream is = new DroolsObjectInputStream((InputStream)new ByteArrayInputStream(object), classLoader);
        String objectId = is.readUTF();
        String canonicalName = is.readUTF();
        String link = is.readUTF();
        Document document = null;
        try {
            document = (Document)Class.forName(canonicalName).newInstance();
            Document storedDoc = this.documentStorageService.getDocument(objectId);
            document.setIdentifier(storedDoc.getIdentifier());
            document.setName(storedDoc.getName());
            document.setLink(link);
            document.setLastModified(storedDoc.getLastModified());
            document.setSize(storedDoc.getSize());
            document.setAttributes(storedDoc.getAttributes());
            document.setContent(storedDoc.getContent());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot read document from storage service", e);
        }
        return document;
    }

    public ObjectMarshallingStrategy.Context createContext() {
        return null;
    }
}

