/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.client.jaxb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.kie.remote.client.jaxb.JaxbCommandsRequest;
import org.kie.remote.client.jaxb.JaxbCommandsResponse;
import org.kie.remote.client.jaxb.JaxbContentResponse;
import org.kie.remote.client.jaxb.JaxbTaskResponse;
import org.kie.remote.client.jaxb.JaxbTaskSummaryListResponse;
import org.kie.services.client.serialization.JaxbSerializationProvider;
import org.kie.services.client.serialization.SerializationException;

public class ClientJaxbSerializationProvider
extends JaxbSerializationProvider {
    private static Set<Class<?>> CLIENT_SIDE_JAXB_CLASS_SET;
    private static Class<?>[] ALL_BASE_JAXB_CLASSES;
    private JAXBContext jaxbContext = null;
    protected Set<Class<?>> extraJaxbClasses = new HashSet();

    public static Set<Class<?>> getModuleClasses() {
        return CLIENT_SIDE_JAXB_CLASS_SET;
    }

    private Class<?>[] getAllJaxbClasses() {
        Class<?>[] allBaseJaxbClassArr = ClientJaxbSerializationProvider.getAllBaseJaxbClasses();
        if (this.extraJaxbClasses.isEmpty()) {
            return allBaseJaxbClassArr;
        }
        Class[] extraJaxbClassArr = this.extraJaxbClasses.toArray(new Class[this.extraJaxbClasses.size()]);
        return ClientJaxbSerializationProvider.addClassArrToClassArr(allBaseJaxbClassArr, extraJaxbClassArr);
    }

    public static Class<?>[] getAllBaseJaxbClasses() {
        Set<Class<?>> sideJaxbClassSet = ClientJaxbSerializationProvider.getModuleClasses();
        Class[] sideJaxbClasses = new Class[sideJaxbClassSet.size()];
        sideJaxbClasses = sideJaxbClassSet.toArray(sideJaxbClasses);
        return ClientJaxbSerializationProvider.addClassArrToClassArr(ALL_BASE_JAXB_CLASSES, sideJaxbClasses);
    }

    private static Class<?>[] addClassArrToClassArr(Class<?>[] baseArr, Class<?>[] addArr) {
        Class[] copy = new Class[baseArr.length + addArr.length];
        System.arraycopy(baseArr, 0, copy, 0, baseArr.length);
        System.arraycopy(addArr, 0, copy, baseArr.length, addArr.length);
        return copy;
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    public static JaxbSerializationProvider newInstance() {
        ClientJaxbSerializationProvider jaxbSerProvider = new ClientJaxbSerializationProvider();
        jaxbSerProvider.initialize();
        return jaxbSerProvider;
    }

    public static JaxbSerializationProvider newInstance(Collection<Class<?>> extraJaxbClassList) {
        ClientJaxbSerializationProvider jaxbSerProvider = new ClientJaxbSerializationProvider(extraJaxbClassList);
        jaxbSerProvider.initialize();
        return jaxbSerProvider;
    }

    private void initialize() {
        this.initialize(this.getAllJaxbClasses());
    }

    private void initialize(Class<?>[] jaxbClasses) {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])jaxbClasses);
        }
        catch (JAXBException jaxbe) {
            throw new SerializationException("Unsupported JAXB Class encountered during initialization: " + jaxbe.getMessage(), (Throwable)jaxbe);
        }
    }

    public void dispose() {
        if (this.extraJaxbClasses != null) {
            this.extraJaxbClasses.clear();
            this.extraJaxbClasses = null;
        }
        if (this.jaxbContext != null) {
            this.jaxbContext = null;
        }
    }

    public void addJaxbClasses(Class ... jaxbClass) {
        for (int i = 0; i < jaxbClass.length; ++i) {
            this.extraJaxbClasses.add(jaxbClass[i]);
        }
    }

    public void addJaxbClassesAndReinitialize(Class ... jaxbClass) {
        this.addJaxbClasses(jaxbClass);
        this.initialize(this.getAllJaxbClasses());
    }

    public Collection<Class<?>> getExtraJaxbClasses() {
        return new HashSet(this.extraJaxbClasses);
    }

    private ClientJaxbSerializationProvider() {
    }

    private ClientJaxbSerializationProvider(Collection<Class<?>> extraJaxbClassArr) {
        this.extraJaxbClasses.addAll(extraJaxbClassArr);
    }

    private ClientJaxbSerializationProvider(Class<?>[] extraJaxbClassArr) {
        this.extraJaxbClasses.addAll(Arrays.asList(extraJaxbClassArr));
    }

    static {
        Class[] serviceSideClasses = new Class[]{JaxbCommandsRequest.class, JaxbCommandsResponse.class, JaxbContentResponse.class, JaxbTaskResponse.class, JaxbTaskSummaryListResponse.class};
        ArrayList<Class> serverSideJaxbClassList = new ArrayList<Class>();
        for (Class clazz : serviceSideClasses) {
            serverSideJaxbClassList.add(clazz);
        }
        CLIENT_SIDE_JAXB_CLASS_SET = Collections.unmodifiableSet(new HashSet(serverSideJaxbClassList));
        ALL_BASE_JAXB_CLASSES = null;
        int kieJaxbClassSetLength = KIE_JAXB_CLASS_SET.size();
        Class[] types = new Class[kieJaxbClassSetLength + PRIMITIVE_ARRAY_CLASS_SET.size()];
        System.arraycopy(KIE_JAXB_CLASS_SET.toArray(new Class[kieJaxbClassSetLength]), 0, types, 0, kieJaxbClassSetLength);
        int primArrClassSetLength = PRIMITIVE_ARRAY_CLASS_SET.size();
        System.arraycopy(PRIMITIVE_ARRAY_CLASS_SET.toArray(new Class[primArrClassSetLength]), 0, types, kieJaxbClassSetLength, primArrClassSetLength);
        ALL_BASE_JAXB_CLASSES = types;
    }
}

