/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api;

import java.net.URL;
import java.util.HashSet;
import org.kie.remote.client.api.RemoteRestRuntimeEngineBuilder;
import org.kie.remote.client.api.RemoteRestRuntimeEngineFactory;
import org.kie.remote.client.api.exception.InsufficientInfoToBuildException;
import org.kie.services.client.api.RemoteRuntimeEngineFactory;
import org.kie.services.client.api.command.RemoteConfiguration;
import org.kie.services.client.api.command.RemoteRuntimeEngine;

class RemoteRestRuntimeEngineBuilderImpl
implements RemoteRestRuntimeEngineBuilder {
    private RemoteConfiguration config = new RemoteConfiguration(RemoteConfiguration.Type.REST);
    URL url;

    RemoteRestRuntimeEngineBuilderImpl() {
    }

    @Override
    public RemoteRestRuntimeEngineBuilderImpl addDeploymentId(String deploymentId) {
        this.config.setDeploymentId(deploymentId);
        return this;
    }

    @Override
    public RemoteRestRuntimeEngineBuilderImpl addProcessInstanceId(long processInstanceId) {
        this.config.setProcessInstanceId(processInstanceId);
        return this;
    }

    @Override
    public RemoteRestRuntimeEngineBuilderImpl addUserName(String userName) {
        this.config.setUserName(userName);
        return this;
    }

    @Override
    public RemoteRestRuntimeEngineBuilderImpl addPassword(String password) {
        this.config.setPassword(password);
        return this;
    }

    @Override
    public RemoteRestRuntimeEngineBuilderImpl addUrl(URL url) {
        this.config.setServerBaseRestUrl(url);
        return this;
    }

    @Override
    public RemoteRestRuntimeEngineBuilderImpl addTimeout(int timeoutInSeconds) {
        this.config.setTimeout(timeoutInSeconds);
        return this;
    }

    @Override
    public RemoteRestRuntimeEngineBuilderImpl addExtraJaxbClasses(Class ... classes) {
        HashSet classSet = new HashSet();
        for (Class clazz : classes) {
            classSet.add(clazz);
        }
        this.config.addJaxbClasses(classSet);
        return this;
    }

    @Override
    public RemoteRestRuntimeEngineBuilderImpl clearJaxbClasses() {
        this.config.clearJaxbClasses();
        return this;
    }

    @Override
    @Deprecated
    public RemoteRestRuntimeEngineBuilderImpl useFormBasedAuth(boolean formBasedAuth) {
        return this;
    }

    private void checkAndFinalizeConfig() {
        RemoteRuntimeEngineFactory.checkAndFinalizeConfig(this.config, this);
    }

    @Override
    public RemoteRestRuntimeEngineFactory buildFactory() throws InsufficientInfoToBuildException {
        this.checkAndFinalizeConfig();
        return new RemoteRestRuntimeEngineFactory(this.config.clone());
    }

    @Override
    public RemoteRuntimeEngine build() {
        this.checkAndFinalizeConfig();
        return new RemoteRuntimeEngine(this.config.clone());
    }

    public static RemoteRestRuntimeEngineBuilderImpl newBuilder() {
        return new RemoteRestRuntimeEngineBuilderImpl();
    }
}

