/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api.command;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.kie.remote.client.api.exception.InsufficientInfoToBuildException;
import org.kie.remote.client.api.exception.RemoteCommunicationException;
import org.kie.remote.client.jaxb.ClientJaxbSerializationProvider;
import org.kie.remote.common.rest.KieRemoteHttpRequest;
import org.kie.services.client.serialization.JaxbSerializationProvider;

public final class RemoteConfiguration {
    public static final String SSL_CONNECTION_FACTORY_NAME = "jms/SslRemoteConnectionFactory";
    public static final String CONNECTION_FACTORY_NAME = "jms/RemoteConnectionFactory";
    public static final String SESSION_QUEUE_NAME = "jms/queue/KIE.SESSION";
    public static final String TASK_QUEUE_NAME = "jms/queue/KIE.TASK";
    public static final String RESPONSE_QUEUE_NAME = "jms/queue/KIE.RESPONSE";
    public static final int DEFAULT_TIMEOUT_IN_SECS = 5;
    private long timeoutInMillisecs = 5000L;
    private final Type type;
    private String deploymentId;
    private Long processInstanceId;
    private String userName;
    private String password;
    private URL serverBaseRestUrl;
    private Set<Class<?>> extraJaxbClasses = new HashSet();
    private JaxbSerializationProvider jaxbSerializationProvider;
    private boolean useSsl = false;
    private boolean doNotUseSsl = false;
    private ConnectionFactory connectionFactory;
    private Queue ksessionQueue;
    private Queue taskQueue;
    private Queue responseQueue;
    private int jmsSerializationType = 0;

    public RemoteConfiguration(Type type) {
        this.type = type;
    }

    public void dispose() {
        if (this.jaxbSerializationProvider != null) {
            this.jaxbSerializationProvider.dispose();
            this.jaxbSerializationProvider = null;
        }
        if (this.extraJaxbClasses != null) {
            this.extraJaxbClasses.clear();
            this.extraJaxbClasses = null;
        }
        if (this.connectionFactory != null) {
            this.connectionFactory = null;
        }
        if (this.ksessionQueue != null) {
            this.ksessionQueue = null;
        }
        if (this.taskQueue != null) {
            this.taskQueue = null;
        }
        if (this.responseQueue != null) {
            this.responseQueue = null;
        }
    }

    public void initializeJaxbSerializationProvider() {
        this.jaxbSerializationProvider = this.extraJaxbClasses != null ? ClientJaxbSerializationProvider.newInstance(this.extraJaxbClasses) : ClientJaxbSerializationProvider.newInstance();
    }

    public RemoteConfiguration(String deploymentId, URL url, String username, String password) {
        this(deploymentId, url, username, password, 5);
    }

    public RemoteConfiguration(String deploymentId, URL url, String username, String password, int timeoutInSecs) {
        this.type = Type.REST;
        this.deploymentId = deploymentId;
        this.userName = username;
        this.password = password;
        this.timeoutInMillisecs = timeoutInSecs * 1000;
    }

    URL initializeRestServicesUrl(URL url) {
        URL serverPlusRestUrl;
        if (url == null) {
            throw new IllegalArgumentException("The url may not be empty or null.");
        }
        try {
            url.toURI();
        }
        catch (URISyntaxException urise) {
            throw new IllegalArgumentException("URL (" + url.toExternalForm() + ") is incorrectly formatted: " + urise.getMessage(), urise);
        }
        String urlString = url.toExternalForm();
        if (!urlString.endsWith("/")) {
            urlString = urlString + "/";
        }
        urlString = urlString + "rest";
        try {
            serverPlusRestUrl = new URL(urlString);
        }
        catch (MalformedURLException murle) {
            throw new IllegalArgumentException("URL (" + url.toExternalForm() + ") is incorrectly formatted: " + murle.getMessage(), murle);
        }
        return serverPlusRestUrl;
    }

    KieRemoteHttpRequest createHttpRequest() {
        return KieRemoteHttpRequest.newRequest((URL)this.serverBaseRestUrl, (String)this.userName, (String)this.password).timeout(this.timeoutInMillisecs);
    }

    public RemoteConfiguration(String deploymentId, ConnectionFactory connectionFactory, Queue ksessionQueue, Queue taskQueue, Queue responseQueue) {
        this.deploymentId = deploymentId;
        this.type = Type.JMS;
        this.setQueuesAndConnectionFactory(connectionFactory, ksessionQueue, taskQueue, responseQueue);
    }

    public void setQueuesAndConnectionFactory(ConnectionFactory connectionFactory, Queue ksessionQueue, Queue taskQueue, Queue responseQueue) {
        this.connectionFactory = connectionFactory;
        this.ksessionQueue = ksessionQueue;
        this.taskQueue = taskQueue;
        this.responseQueue = responseQueue;
        RemoteConfiguration.checkValidValues(this.connectionFactory, this.ksessionQueue, this.taskQueue, this.responseQueue);
    }

    public void checkValidJmsValues() {
        RemoteConfiguration.checkValidValues(this.connectionFactory, this.ksessionQueue, this.taskQueue, this.responseQueue);
    }

    private static void checkValidValues(ConnectionFactory connectionFactory, Queue ksessionQueue, Queue taskQueue, Queue responseQueue) throws InsufficientInfoToBuildException {
        if (connectionFactory == null) {
            throw new InsufficientInfoToBuildException("The connection factory argument may not be null.");
        }
        if (ksessionQueue == null && taskQueue == null) {
            throw new InsufficientInfoToBuildException("At least a ksession queue or task queue is required.");
        }
        if (responseQueue == null) {
            throw new InsufficientInfoToBuildException("The response queue argument may not be null.");
        }
    }

    public RemoteConfiguration(String deploymentId, ConnectionFactory connectionFactory, Queue ksessionQueue, Queue taskQueue, Queue responseQueue, String username, String password) {
        this(deploymentId, connectionFactory, ksessionQueue, taskQueue, responseQueue);
        this.setAndCheckUserNameAndPassword(username, password);
    }

    public RemoteConfiguration(String deploymentId, InitialContext context, String username, String password) {
        this.deploymentId = deploymentId;
        this.type = Type.JMS;
        this.setAndCheckUserNameAndPassword(username, password);
        this.setRemoteInitialContext(context);
    }

    public void setRemoteInitialContext(InitialContext context) {
        String prop = CONNECTION_FACTORY_NAME;
        try {
            if (this.connectionFactory == null) {
                this.connectionFactory = (ConnectionFactory)context.lookup(prop);
            }
            prop = SESSION_QUEUE_NAME;
            this.ksessionQueue = (Queue)context.lookup(prop);
            prop = TASK_QUEUE_NAME;
            this.taskQueue = (Queue)context.lookup(prop);
            prop = RESPONSE_QUEUE_NAME;
            this.responseQueue = (Queue)context.lookup(prop);
        }
        catch (NamingException ne) {
            throw new RemoteCommunicationException("Unable to retrieve object for " + prop, ne);
        }
        RemoteConfiguration.checkValidValues(this.connectionFactory, this.ksessionQueue, this.taskQueue, this.responseQueue);
    }

    private void setAndCheckUserNameAndPassword(String username, String password) {
        if (username == null || username.trim().isEmpty()) {
            throw new IllegalArgumentException("The user name may not be empty or null.");
        }
        this.userName = username;
        if (password == null) {
            throw new IllegalArgumentException("The password may not be null.");
        }
        this.password = password;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    int getSerializationType() {
        return this.jmsSerializationType;
    }

    boolean isJms() {
        assert (this.type != null) : "type is null!";
        return this.type == Type.JMS;
    }

    boolean isRest() {
        assert (this.type != null) : "type is null!";
        return this.type == Type.REST;
    }

    public URL getServerBaseRestUrl() {
        return this.serverBaseRestUrl;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    ConnectionFactory getConnectionFactory() {
        assert (this.connectionFactory != null) : "connectionFactory value should not be null!";
        return this.connectionFactory;
    }

    Queue getKsessionQueue() {
        return this.ksessionQueue;
    }

    Queue getTaskQueue() {
        return this.taskQueue;
    }

    Queue getResponseQueue() {
        assert (this.responseQueue != null) : "responseQueue value should not be null!";
        return this.responseQueue;
    }

    public boolean addJaxbClasses(Set<Class<?>> extraJaxbClassList) {
        return this.extraJaxbClasses.addAll(extraJaxbClassList);
    }

    public void clearJaxbClasses() {
        this.extraJaxbClasses.clear();
    }

    public Set<Class<?>> getExtraJaxbClasses() {
        return this.extraJaxbClasses;
    }

    JaxbSerializationProvider getJaxbSerializationProvider() {
        return this.jaxbSerializationProvider;
    }

    public Type getType() {
        return this.type;
    }

    public long getTimeout() {
        return this.timeoutInMillisecs;
    }

    public boolean getUseUssl() {
        return this.useSsl;
    }

    public boolean getDoNotUseSsl() {
        return this.doNotUseSsl;
    }

    Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setTimeout(long timeout) {
        this.timeoutInMillisecs = timeout * 1000L;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setServerBaseRestUrl(URL url) {
        URL checkedModifiedUrl;
        this.serverBaseRestUrl = checkedModifiedUrl = this.initializeRestServicesUrl(url);
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setExtraJaxbClasses(Set<Class<?>> extraJaxbClasses) {
        this.extraJaxbClasses = extraJaxbClasses;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setKsessionQueue(Queue ksessionQueue) {
        this.ksessionQueue = ksessionQueue;
    }

    public void setTaskQueue(Queue taskQueue) {
        this.taskQueue = taskQueue;
    }

    public void setResponseQueue(Queue responseQueue) {
        this.responseQueue = responseQueue;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public void setDoNotUseSssl(boolean doNotUseSsl) {
        this.doNotUseSsl = doNotUseSsl;
    }

    private RemoteConfiguration(RemoteConfiguration config) {
        this.connectionFactory = config.connectionFactory;
        this.deploymentId = config.deploymentId;
        this.extraJaxbClasses = config.extraJaxbClasses;
        this.jmsSerializationType = config.jmsSerializationType;
        this.ksessionQueue = config.ksessionQueue;
        this.password = config.password;
        this.processInstanceId = config.processInstanceId;
        this.responseQueue = config.responseQueue;
        this.serverBaseRestUrl = config.serverBaseRestUrl;
        this.taskQueue = config.taskQueue;
        this.timeoutInMillisecs = config.timeoutInMillisecs;
        this.type = config.type;
        this.userName = config.userName;
        this.useSsl = config.useSsl;
        this.doNotUseSsl = config.doNotUseSsl;
    }

    public RemoteConfiguration clone() {
        return new RemoteConfiguration(this);
    }

    public static enum Type {
        REST,
        JMS,
        CONSTRUCTOR;

    }
}

