/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.serialization.jaxb.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import org.kie.services.client.serialization.jaxb.impl.JaxbRequestStatus;

@XmlRootElement(name="exception")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JaxbRestRequestException {
    @XmlTransient
    public Exception cause;
    @XmlElement
    protected JaxbRequestStatus status;
    @XmlElement
    @XmlSchemaType(name="anyURI")
    protected String url;
    @XmlElement
    @XmlSchemaType(name="string")
    private String message;
    @XmlElement
    @XmlSchemaType(name="string")
    private String stackTrace;

    public JaxbRestRequestException() {
    }

    public JaxbRestRequestException(Exception e, JaxbRequestStatus status) {
        this.initializeExceptionAndMessage(e);
        this.status = status;
    }

    public JaxbRestRequestException(String requestUrl, Exception e, JaxbRequestStatus status) {
        this.url = requestUrl;
        this.status = status;
        this.initializeExceptionAndMessage(e);
    }

    private void initializeExceptionAndMessage(Exception e) {
        if (e != null) {
            this.cause = e;
            this.message = e.getClass().getSimpleName() + " thrown with message '" + e.getMessage() + "'";
            if (e.getCause() != null) {
                Throwable t = e.getCause();
                this.message = t.getClass().getSimpleName() + " thrown with message '" + t.getMessage() + "'";
            }
            this.stackTrace = JaxbRestRequestException.convertStackTraceToString(e);
        }
    }

    public static String convertStackTraceToString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        return stringWriter.toString();
    }

    public String prettyPrint() throws JAXBException {
        StringWriter writer = new StringWriter();
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{this.getClass()});
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)this, (Writer)writer);
        return writer.toString();
    }

    public String getResult() {
        return this.message;
    }

    public void setResult(String result) {
        this.message = result;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Exception getCause() {
        return this.cause;
    }

    public void setCause(Exception cause) {
        this.cause = cause;
        if (cause != null) {
            this.stackTrace = JaxbRestRequestException.convertStackTraceToString(cause);
        }
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }
}

