/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.query.jpa.data;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.persistence.criteria.Predicate;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.jbpm.query.jpa.data.QueryCriteria;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(value={"union", "type", "currentGroupCriteria", "ancestry", "currentParent", "addedJoins"})
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class QueryWhere {
    @XmlElement(name="queryCriteria")
    private List<QueryCriteria> criteria = new LinkedList<QueryCriteria>();
    @XmlElement
    private Boolean ascOrDesc = null;
    @XmlElement
    private String orderByListId = null;
    @XmlElement
    private Integer maxResults = null;
    @XmlElement
    private Integer offset = null;
    @JsonIgnore
    private transient boolean union = true;
    @JsonIgnore
    private transient QueryCriteriaType type = QueryCriteriaType.NORMAL;
    @JsonIgnore
    private transient List<QueryCriteria> currentCriteria = this.criteria;
    @JsonIgnore
    private transient Stack<Object> ancestry = new Stack();
    @JsonIgnore
    private transient Object currentParent = this;
    @JsonIgnore
    private transient Map<String, Predicate> joinPredicates = null;

    public QueryWhere() {
    }

    public <T> QueryCriteria addParameter(String listId, T ... param) {
        if (param.length == 0) {
            return null;
        }
        if (QueryCriteriaType.REGEXP.equals((Object)this.type) && !(param[0] instanceof String)) {
            throw new IllegalArgumentException("Only String parameters may be used in regular expressions.");
        }
        QueryCriteria criteria = new QueryCriteria(listId, this.union, this.type, param.length);
        for (T paramElem : param) {
            criteria.addParameter(paramElem);
        }
        this.addCriteria(criteria);
        return criteria;
    }

    public <T> void addRangeParameter(String listId, T param, boolean start) {
        QueryCriteriaType origType = this.type;
        this.type = QueryCriteriaType.RANGE;
        QueryCriteria criteria = new QueryCriteria(listId, this.union, this.type, 2);
        int index = start ? 0 : 1;
        criteria.setParameter(index, param, 2);
        this.addCriteria(criteria);
        this.type = origType;
    }

    public <T> void addRangeParameters(String listId, T paramMin, T paramMax) {
        QueryCriteriaType origType = this.type;
        this.type = QueryCriteriaType.RANGE;
        QueryCriteria criteria = new QueryCriteria(listId, this.union, this.type, 2);
        criteria.addParameter(paramMin);
        criteria.addParameter(paramMax);
        this.addCriteria(criteria);
        this.type = origType;
    }

    private void addCriteria(QueryCriteria criteria) {
        if (this.currentCriteria.isEmpty()) {
            criteria.setFirst(true);
        } else if (this.currentCriteria.size() == 1) {
            this.currentCriteria.get(0).setUnion(criteria.isUnion());
        }
        this.currentCriteria.add(criteria);
    }

    public void newGroup() {
        QueryCriteria newCriteriaGroupParent = new QueryCriteria(this.union);
        this.addCriteria(newCriteriaGroupParent);
        this.ancestry.push(this.currentParent);
        this.currentParent = newCriteriaGroupParent;
        this.currentCriteria = newCriteriaGroupParent.getCriteria();
    }

    public void endGroup() {
        if (this.ancestry.isEmpty()) {
            throw new IllegalStateException("Can not end group: no group has been started!");
        }
        Object grandparent = this.ancestry.pop();
        this.currentCriteria = grandparent instanceof QueryWhere ? ((QueryWhere)grandparent).getCriteria() : ((QueryCriteria)grandparent).getCriteria();
        this.currentParent = grandparent;
    }

    @JsonIgnore
    public void setAscending(String listId) {
        this.ascOrDesc = true;
        this.orderByListId = listId;
    }

    @JsonIgnore
    public void setDescending(String listId) {
        this.ascOrDesc = false;
        this.orderByListId = listId;
    }

    public List<QueryCriteria> getCurrentCriteria() {
        return this.currentCriteria;
    }

    public List<QueryCriteria> getCriteria() {
        return this.criteria;
    }

    public void setCriteria(List<QueryCriteria> criteria) {
        this.criteria = criteria;
    }

    public void setParameters(List<QueryCriteria> parameters) {
        this.criteria = parameters;
    }

    public void setAscOrDesc(Boolean ascendingOrDescending) {
        this.ascOrDesc = ascendingOrDescending;
    }

    public Boolean getAscOrDesc() {
        return this.ascOrDesc;
    }

    public void setOrderByListId(String listId) {
        this.orderByListId = listId;
    }

    public String getOrderByListId() {
        return this.orderByListId;
    }

    public void setCount(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getCount() {
        return this.maxResults;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public QueryCriteriaType getCriteriaType() {
        return this.type;
    }

    public void setToUnion() {
        this.union = true;
    }

    public void setToIntersection() {
        this.union = false;
    }

    public boolean isUnion() {
        return this.union;
    }

    public void setToLike() {
        this.type = QueryCriteriaType.REGEXP;
    }

    public boolean isLike() {
        return this.type.equals((Object)QueryCriteriaType.REGEXP);
    }

    public void setToNormal() {
        this.type = QueryCriteriaType.NORMAL;
    }

    public void setToRange() {
        this.type = QueryCriteriaType.RANGE;
    }

    public boolean isRange() {
        return this.type.equals((Object)QueryCriteriaType.RANGE);
    }

    public void setToGroup() {
        this.type = QueryCriteriaType.GROUP;
    }

    public Map<String, Predicate> getJoinPredicates() {
        if (this.joinPredicates == null) {
            this.joinPredicates = new HashMap<String, Predicate>(3);
        }
        return this.joinPredicates;
    }

    public void clear() {
        this.union = true;
        this.type = QueryCriteriaType.NORMAL;
        this.ancestry.clear();
        if (this.criteria != null) {
            this.criteria.clear();
        }
        this.currentCriteria = this.criteria;
        this.maxResults = null;
        this.offset = null;
        this.orderByListId = null;
        this.ascOrDesc = null;
        this.joinPredicates = null;
    }

    public QueryWhere(QueryWhere queryWhere) {
        this.union = queryWhere.union;
        this.type = queryWhere.type;
        if (queryWhere.criteria != null) {
            this.criteria = new LinkedList<QueryCriteria>(queryWhere.criteria);
        }
        this.ascOrDesc = queryWhere.ascOrDesc;
        this.orderByListId = queryWhere.orderByListId;
        this.maxResults = queryWhere.maxResults;
        this.offset = queryWhere.offset;
        this.joinPredicates = queryWhere.joinPredicates;
    }

    @XmlEnum
    public static enum QueryCriteriaType {
        NORMAL,
        REGEXP,
        RANGE,
        GROUP;

    }
}

