/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.debug;

import java.util.Stack;
import org.drools.core.common.NetworkNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.util.Iterator;
import org.drools.core.util.debug.AbstractNetworkNodeVisitor;
import org.drools.core.util.debug.DefaultNodeInfo;
import org.drools.core.util.debug.StatefulKnowledgeSessionInfo;

public class FromNodeVisitor
extends AbstractNetworkNodeVisitor {
    public static final FromNodeVisitor INSTANCE = new FromNodeVisitor();

    protected FromNodeVisitor() {
    }

    @Override
    protected void doVisit(NetworkNode node, Stack<NetworkNode> nodeStack, StatefulKnowledgeSessionInfo info) {
        FromNode fn = (FromNode)node;
        DefaultNodeInfo ni = info.getNodeInfo(node);
        FromNode.FromMemory memory = (FromNode.FromMemory)info.getSession().getNodeMemory(fn);
        ni.setMemoryEnabled(true);
        if (fn.isLeftTupleMemoryEnabled()) {
            ni.setTupleMemorySize(memory.getBetaMemory().getLeftTupleMemory().size());
            long handles = 0L;
            Iterator<LeftTuple> it = memory.getBetaMemory().getLeftTupleMemory().iterator();
            LeftTuple leftTuple = it.next();
            while (leftTuple != null) {
                for (LeftTuple child = leftTuple.getFirstChild(); child != null; child = child.getLeftParentNext()) {
                    ++handles;
                }
                leftTuple = it.next();
            }
            ni.setCreatedFactHandles(handles);
        } else {
            info.warn("The left memory for this node is disabled, making it impossible to calculate the number of created handles");
        }
    }
}

