/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.impl.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SerializableUtil {
    private SerializableUtil() {
    }

    public static byte[] serialize(Serializable object) throws IOException {
        return SerializableUtil.serialize(object, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serialize(Serializable object, ClassLoader classLoader) throws IOException {
        byte[] result;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(outputStream);
            out.writeObject(object);
            result = outputStream.toByteArray();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {}
            try {
                outputStream.close();
            }
            catch (IOException ex) {}
        }
        return result;
    }

    public static Serializable deserialize(byte[] byteArray) throws IOException, ClassNotFoundException {
        return SerializableUtil.deserialize(byteArray, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializable deserialize(byte[] byteArray, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        Serializable result;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        ByteArrayInputStream byteArrayIn = new ByteArrayInputStream(byteArray);
        ObjectInputStream objectIn = null;
        try {
            objectIn = new ObjectInputStream(byteArrayIn);
            result = (Serializable)objectIn.readObject();
        }
        finally {
            try {
                byteArrayIn.close();
            }
            catch (IOException ex) {}
            try {
                if (objectIn != null) {
                    objectIn.close();
                }
            }
            catch (IOException ex) {}
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        return result;
    }
}

