/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql.model;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dashbuilder.dataprovider.sql.JDBCUtils;
import org.dashbuilder.dataprovider.sql.dialect.Dialect;
import org.dashbuilder.dataprovider.sql.model.Column;
import org.dashbuilder.dataprovider.sql.model.SQLStatement;

public class CreateTable
extends SQLStatement<CreateTable> {
    protected List<Column> columns = new ArrayList<Column>();
    protected List<Column> primaryKeys = new ArrayList<Column>();

    public CreateTable(Connection connection, Dialect dialect) {
        super(connection, dialect);
    }

    public CreateTable columns(Column ... cols) {
        for (Column column : cols) {
            this.columns.add(this.fix(column));
        }
        return this;
    }

    public CreateTable primaryKey(Column ... cols) {
        for (Column column : cols) {
            this.primaryKeys.add(this.fix(column));
        }
        return this;
    }

    public String getSQL() {
        StringBuilder sql = new StringBuilder("CREATE TABLE ");
        ArrayList<String> pkeys = new ArrayList<String>();
        String tname = this.dialect.getTableSQL(this);
        sql.append(tname);
        boolean first = true;
        sql.append(" (\n");
        for (Column column : this.columns) {
            if (!first) {
                sql.append(",\n");
            }
            String name = this.dialect.getColumnNameSQL(column.getName());
            String type = this.dialect.getColumnTypeSQL(column);
            sql.append(" ").append(name).append(" ").append(type);
            if (this.primaryKeys.contains(column)) {
                sql.append(" NOT NULL");
                pkeys.add(name);
            }
            first = false;
        }
        if (!this.primaryKeys.isEmpty()) {
            sql.append(",\n");
            sql.append(" PRIMARY KEY(");
            sql.append(StringUtils.join(pkeys, (String)","));
            sql.append(")\n");
        }
        sql.append(")");
        return sql.toString();
    }

    public String toString() {
        return this.getSQL();
    }

    public void execute() throws SQLException {
        String sql = this.getSQL();
        JDBCUtils.execute(this.connection, sql);
    }
}

