/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.wih;

import java.util.Date;
import java.util.List;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.drools.core.time.TimeUtils;
import org.jbpm.executor.impl.wih.AsyncWorkItemHandlerCmdCallback;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.RequestInfo;
import org.kie.api.executor.STATUS;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.query.QueryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncWorkItemHandler
implements WorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(AsyncWorkItemHandler.class);
    private ExecutorService executorService;
    private String commandClass;

    public AsyncWorkItemHandler(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public AsyncWorkItemHandler(ExecutorService executorService, String commandClass) {
        this(executorService);
        this.commandClass = commandClass;
    }

    public AsyncWorkItemHandler(Object executorService, String commandClass) {
        this((ExecutorService)executorService);
        this.commandClass = commandClass;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        if (this.executorService == null || !this.executorService.isActive()) {
            throw new IllegalStateException("Executor is not set or is not active");
        }
        boolean autoComplete = false;
        if (workItem.getParameter("AutoComplete") != null) {
            autoComplete = Boolean.parseBoolean(workItem.getParameter("AutoComplete").toString());
        }
        String businessKey = this.buildBusinessKey(workItem);
        logger.debug("Executing work item {} with built business key {}", (Object)workItem, (Object)businessKey);
        String cmdClass = (String)workItem.getParameter("CommandClass");
        if (cmdClass == null) {
            cmdClass = this.commandClass;
        }
        logger.debug("Command class for this execution is {}", (Object)cmdClass);
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)businessKey);
        ctxCMD.setData("workItem", (Object)workItem);
        ctxCMD.setData("processInstanceId", (Object)this.getProcessInstanceId(workItem));
        ctxCMD.setData("deploymentId", (Object)((WorkItemImpl)workItem).getDeploymentId());
        if (!autoComplete) {
            ctxCMD.setData("callbacks", (Object)AsyncWorkItemHandlerCmdCallback.class.getName());
        }
        if (workItem.getParameter("Retries") != null) {
            ctxCMD.setData("retries", (Object)Integer.parseInt(workItem.getParameter("Retries").toString()));
        }
        if (workItem.getParameter("Owner") != null) {
            ctxCMD.setData("owner", workItem.getParameter("Owner"));
        }
        if (workItem.getParameter("RetryDelay") != null) {
            ctxCMD.setData("retryDelay", workItem.getParameter("RetryDelay"));
        }
        Date scheduleDate = new Date();
        if (workItem.getParameter("Delay") != null) {
            long delayInMillis = TimeUtils.parseTimeString((String)((String)workItem.getParameter("Delay")));
            scheduleDate = new Date(System.currentTimeMillis() + delayInMillis);
        }
        logger.trace("Command context {}", (Object)ctxCMD);
        Long requestId = this.executorService.scheduleRequest(cmdClass, scheduleDate, ctxCMD);
        logger.debug("Request scheduled successfully with id {}", (Object)requestId);
        if (autoComplete) {
            logger.debug("Auto completing work item with id {}", (Object)workItem.getId());
            manager.completeWorkItem(workItem.getId(), null);
        }
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        String businessKey = this.buildBusinessKey(workItem);
        logger.info("Looking up for not cancelled and not done requests for business key {}", (Object)businessKey);
        List requests = this.executorService.getRequestsByBusinessKey(businessKey, new QueryContext());
        if (requests != null) {
            for (RequestInfo request : requests) {
                if (request.getStatus() == STATUS.CANCELLED || request.getStatus() == STATUS.DONE || request.getStatus() == STATUS.ERROR) continue;
                logger.info("About to cancel request with id {} and business key {} request state {}", new Object[]{request.getId(), businessKey, request.getStatus()});
                this.executorService.cancelRequest(request.getId());
            }
        }
    }

    protected String buildBusinessKey(WorkItem workItem) {
        String businessKeyIn = (String)workItem.getParameter("BusinessKey");
        if (businessKeyIn != null && !businessKeyIn.isEmpty()) {
            return businessKeyIn;
        }
        StringBuffer businessKey = new StringBuffer();
        businessKey.append(this.getProcessInstanceId(workItem));
        businessKey.append(":");
        businessKey.append(workItem.getId());
        return businessKey.toString();
    }

    protected long getProcessInstanceId(WorkItem workItem) {
        return ((WorkItemImpl)workItem).getProcessInstanceId();
    }
}

