/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api;

import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.kie.remote.client.api.exception.RemoteApiException;
import org.kie.remote.client.api.exception.RemoteCommunicationException;
import org.kie.remote.client.jaxb.JaxbCommandsRequest;
import org.kie.remote.client.jaxb.JaxbCommandsResponse;
import org.kie.remote.client.ws.KieRemoteWsAuthenticator;
import org.kie.remote.services.ws.command.generated.CommandWebService;
import org.kie.remote.services.ws.command.generated.Execute;
import org.kie.remote.services.ws.command.generated.ExecuteResponse;
import org.kie.services.client.api.RemoteWebserviceClientBuilderImpl;
import org.kie.services.client.api.command.AbstractRemoteCommandObject;

class RemoteCommandWebserviceClientBuilderImpl
extends RemoteWebserviceClientBuilderImpl<CommandWebService> {
    private static final String commandServiceNamespace = "http://services.remote.kie.org/6.4.0.1/command";
    private static final QName commandServiceQName = new QName("http://services.remote.kie.org/6.4.0.1/command", "CommandServiceBasicAuth");

    RemoteCommandWebserviceClientBuilderImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandWebService buildBasicAuthClient() {
        JAXBDataBinding jaxbDataBinding;
        URL wsdlUrl;
        this.checkAndFinalizeConfig();
        String wsdlLocationRelativePath = this.config.getWsdlLocationRelativePath();
        try {
            wsdlUrl = new URL(this.config.getServerBaseUrl(), wsdlLocationRelativePath);
        }
        catch (MalformedURLException murle) {
            throw new IllegalStateException("WSDL URL is not correct: [" + this.config.getServerBaseUrl().toExternalForm() + wsdlLocationRelativePath + "]", murle);
        }
        String userName = this.config.getConnectionUserName();
        String password = this.config.getConnectionPassword();
        wsdlUrl = this.verifyURLWithRedirect(wsdlUrl, userName, password);
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(CommandWebService.class);
        factory.setWsdlURL(wsdlUrl.toExternalForm());
        factory.setServiceName(commandServiceQName);
        HashSet allClasses = new HashSet();
        allClasses.add(JaxbCommandsRequest.class);
        allClasses.add(JaxbCommandsResponse.class);
        allClasses.add(Execute.class);
        allClasses.add(ExecuteResponse.class);
        Set<Class<?>> extraClasses = this.config.getExtraJaxbClasses();
        if (extraClasses != null && !extraClasses.isEmpty()) {
            allClasses.addAll(extraClasses);
        }
        try {
            jaxbDataBinding = new JAXBDataBinding(allClasses.toArray(new Class[allClasses.size()]));
        }
        catch (JAXBException jaxbe) {
            throw new RemoteApiException("Unable to initialize JAXB context for webservice client", jaxbe);
        }
        factory.getClientFactoryBean().setDataBinding((DataBinding)jaxbDataBinding);
        factory.setUsername(userName);
        factory.setPassword(password);
        CommandWebService commandService = null;
        KieRemoteWsAuthenticator authenticator = KieRemoteWsAuthenticator.getInstance();
        try {
            authenticator.setUserAndPassword(userName, password);
            commandService = (CommandWebService)factory.create(CommandWebService.class);
        }
        finally {
            authenticator.clearUserAndPassword();
        }
        Client proxyClient = ClientProxy.getClient((Object)commandService);
        HTTPConduit conduit = (HTTPConduit)proxyClient.getConduit();
        HTTPClientPolicy httpClientPolicy = conduit.getClient();
        httpClientPolicy.setConnectionTimeout(this.config.getTimeout());
        httpClientPolicy.setReceiveTimeout(this.config.getTimeout());
        httpClientPolicy.setAutoRedirect(this.config.getHttpRedirect());
        String deploymentId = this.config.getDeploymentId();
        if (!AbstractRemoteCommandObject.emptyDeploymentId(deploymentId)) {
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>(1);
            String[] depIdHeader = new String[]{deploymentId};
            headers.put("Kie-Deployment-Id", Arrays.asList(depIdHeader));
            proxyClient.getRequestContext().put(Message.PROTOCOL_HEADERS, headers);
        }
        return commandService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private URL verifyURLWithRedirect(URL wsdlUrl, String userName, String password) {
        redirectTries = 0;
        newWsdlUrl = wsdlUrl;
        connStatus = -1;
        block11: do {
            wsdlUrl = newWsdlUrl;
            conn = null;
            try {
                try {
                    conn = (HttpURLConnection)wsdlUrl.openConnection();
                    conn.setInstanceFollowRedirects(false);
                    encoded = Base64Utility.encode((byte[])(userName + ":" + password).getBytes("UTF-8"));
                    conn.setRequestProperty("Authorization", "Basic " + encoded);
                    connStatus = conn.getResponseCode();
                }
                catch (Exception e) {
                    throw new RemoteCommunicationException("Could not verify WSDL URL: [" + wsdlUrl.toExternalForm() + "]", e);
                }
                switch (connStatus) {
                    case 200: {
                        ** break;
lbl20:
                        // 1 sources

                        continue block11;
                    }
                    case 301: 
                    case 302: 
                    case 303: {
                        newWsdlLoc = conn.getHeaderField("Location");
                        if (this.config.getHttpRedirect()) {
                            if (newWsdlLoc.startsWith("/")) {
                                baseUrl = this.config.getServerBaseUrl();
                                newWsdlLoc = baseUrl.getProtocol() + "://" + baseUrl.getAuthority() + newWsdlLoc;
                            } else if (!newWsdlLoc.startsWith("http")) {
                                throw new RemoteCommunicationException("Could not parse redirect URL: [" + newWsdlLoc + "]");
                            }
                            try {
                                newWsdlUrl = new URL(newWsdlLoc);
                                ** break;
lbl33:
                                // 1 sources

                                continue block11;
                            }
                            catch (MalformedURLException murle) {
                                throw new RemoteCommunicationException("Redirect URL returned by server is invalid: [" + newWsdlLoc + "]", murle);
                            }
                        }
                        throw new RemoteCommunicationException("HTTP Redirect is not set but server redirected client to [" + newWsdlLoc + "]");
                    }
                    default: {
                        throw new RemoteCommunicationException("Status " + connStatus + " received when verifying WSDL URL: [" + wsdlUrl.toExternalForm() + "]");
                    }
                }
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        } while (++redirectTries < 3 && !wsdlUrl.equals(newWsdlUrl) && connStatus != 200);
        if (connStatus != 200) {
            if (newWsdlUrl.equals(wsdlUrl) && connStatus >= 300 && connStatus < 400) {
                throw new RemoteCommunicationException("Unable to verify WSDL URL: request returned a redirect to the same URL [" + newWsdlUrl + "]");
            }
            throw new RemoteCommunicationException("Unable to verify WSDL URL: request returned status " + connStatus + " after " + redirectTries + " redirects [" + newWsdlUrl + "]");
        }
        if (!wsdlUrl.equals(newWsdlUrl)) {
            throw new RemoteCommunicationException("Server redirected (WSDL) request 3 times in a row. The last request URL was [" + newWsdlUrl + "]");
        }
        return wsdlUrl;
    }
}

