/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eap.test;

import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.utils.KieHelper;

@RunWith(value=Arquillian.class)
public class KieEapModulesSmokeIT {
    private static final String RULE_PKG_NAME = "org.kie.eap.test";

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource("jboss-deployment-structure-drools-and-jbpm-modules.xml", "jboss-deployment-structure.xml")).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void deployWarWithDroolsAndJbpmModuleDependencies(@ArquillianResource URL baseUrl) {
        Assert.assertNotNull((Object)baseUrl);
    }

    @Test
    public void createKieSessionFromSimpleDrlAndFireRules() {
        String drl = "package org.kie.eap.test;\n\nrule \"Dummy rule\"\nwhen\n    String( this == \"MyValue\" )\nthen\n    System.out.println(\"Rule fired!\");\nend";
        KieHelper kieHelper = new KieHelper();
        kieHelper.addContent(drl, ResourceType.DRL);
        KieBase kieBase = kieHelper.build(new KieBaseOption[0]);
        Assert.assertFalse((String)"At least one KiePackage expected!", (boolean)kieBase.getKiePackages().isEmpty());
        Assert.assertTrue((String)("Expected KiePackage org.kie.eap.test not found in " + kieBase.getKiePackages()), (boolean)kieBase.getKiePackages().stream().anyMatch(kp -> RULE_PKG_NAME.equals(kp.getName())));
        KieSession kieSession = kieBase.newKieSession();
        kieSession.insert((Object)"MyValue");
        int rulesFired = kieSession.fireAllRules();
        Assert.assertEquals((String)"Unexpected number of rules fired!", (long)1L, (long)rulesFired);
    }
}

