/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.runtime.manager.deploy;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.internal.runtime.conf.AuditMode;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.NamedObjectModel;
import org.kie.internal.runtime.conf.ObjectModel;
import org.kie.internal.runtime.conf.PersistenceMode;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorIO;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;
import org.kie.internal.runtime.manager.deploy.TransientNamedObjectModel;
import org.kie.internal.runtime.manager.deploy.TransientObjectModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentDescriptorTest {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentDescriptorTest.class);

    @Test
    public void testWriteDeploymentDescriptorXml() {
        DeploymentDescriptorImpl descriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        descriptor.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.testCustomStrategy", new Object[]{new ObjectModel("java.lang.String", new Object[]{"param1"}), "param2"})).addRequiredRole("experts");
        String deploymentDescriptorXml = descriptor.toXml();
        Assert.assertNotNull((Object)deploymentDescriptorXml);
        logger.info(deploymentDescriptorXml);
        ByteArrayInputStream stream = new ByteArrayInputStream(deploymentDescriptorXml.getBytes());
        DeploymentDescriptor fromXml = DeploymentDescriptorIO.fromXml((InputStream)stream);
        Assert.assertNotNull((Object)fromXml);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)fromXml.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)fromXml.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)fromXml.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)fromXml.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)fromXml.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)fromXml.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)fromXml.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)fromXml.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)fromXml.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)fromXml.getGlobals().size());
        Assert.assertEquals((long)0L, (long)fromXml.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)fromXml.getWorkItemHandlers().size());
        Assert.assertEquals((long)1L, (long)fromXml.getRequiredRoles().size());
    }

    @Test
    public void testReadDeploymentDescriptorFromXml() throws Exception {
        InputStream input = this.getClass().getResourceAsStream("/deployment/deployment-descriptor-defaults.xml");
        DeploymentDescriptor descriptor = DeploymentDescriptorIO.fromXml((InputStream)input);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getWorkItemHandlers().size());
        Assert.assertEquals((long)0L, (long)descriptor.getRequiredRoles().size());
    }

    @Test
    public void testReadDeploymentDescriptorMSFromXml() throws Exception {
        InputStream input = this.getClass().getResourceAsStream("/deployment/deployment-descriptor-defaults-and-ms.xml");
        DeploymentDescriptor descriptor = DeploymentDescriptorIO.fromXml((InputStream)input);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getWorkItemHandlers().size());
        Assert.assertEquals((long)1L, (long)descriptor.getRequiredRoles().size());
    }

    @Test
    public void testReadPartialDeploymentDescriptorFromXml() throws Exception {
        InputStream input = this.getClass().getResourceAsStream("/deployment/partial-deployment-descriptor.xml");
        DeploymentDescriptor descriptor = DeploymentDescriptorIO.fromXml((InputStream)input);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.PER_PROCESS_INSTANCE, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getWorkItemHandlers().size());
        Assert.assertEquals((long)0L, (long)descriptor.getRequiredRoles().size());
    }

    @Test
    public void testCreateDeploymentDescriptorWithSetters() {
        DeploymentDescriptorImpl descriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        descriptor.setAuditMode(AuditMode.JMS);
        descriptor.setEnvironmentEntries(null);
        ArrayList<ObjectModel> marshallingStrategies = new ArrayList<ObjectModel>();
        marshallingStrategies.add(new ObjectModel("org.jbpm.testCustomStrategy", new Object[]{new ObjectModel("java.lang.String", new Object[]{"param1"}), "param2"}));
        descriptor.setMarshallingStrategies(marshallingStrategies);
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("experts");
        descriptor.setRequiredRoles(roles);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getWorkItemHandlers().size());
        Assert.assertEquals((long)1L, (long)descriptor.getRequiredRoles().size());
    }

    @Test
    public void testPrintDescriptor() {
        DeploymentDescriptorImpl descriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        descriptor.getBuilder().addWorkItemHandler(new NamedObjectModel("mvel", "Log", "new org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler()", new Object[0])).addWorkItemHandler(new NamedObjectModel("mvel", "WebService", "new org.jbpm.process.workitem.webservice.WebServiceWorkItemHandler(ksession)", new Object[0])).addWorkItemHandler(new NamedObjectModel("mvel", "Rest", "new org.jbpm.process.workitem.rest.RESTWorkItemHandler()", new Object[0])).addWorkItemHandler(new NamedObjectModel("mvel", "Service Task", "new org.jbpm.process.workitem.bpmn2.ServiceTaskHandler(ksession)", new Object[0]));
        logger.debug(descriptor.toXml());
    }

    @Test
    public void testWriteDeploymentDescriptorXmlWithDuplicateNamedObjects() {
        DeploymentDescriptorImpl descriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        descriptor.getBuilder().addWorkItemHandler(new NamedObjectModel("mvel", "Log", "new org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler()", new Object[0])).addWorkItemHandler(new NamedObjectModel("mvel", "Log", "new org.jbpm.process.instance.impl.demo.CustomSystemOutWorkItemHandler()", new Object[0])).addRequiredRole("experts");
        String deploymentDescriptorXml = descriptor.toXml();
        Assert.assertNotNull((Object)deploymentDescriptorXml);
        logger.info(deploymentDescriptorXml);
        ByteArrayInputStream stream = new ByteArrayInputStream(deploymentDescriptorXml.getBytes());
        DeploymentDescriptor fromXml = DeploymentDescriptorIO.fromXml((InputStream)stream);
        Assert.assertNotNull((Object)fromXml);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)fromXml.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)fromXml.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)fromXml.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)fromXml.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)fromXml.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)fromXml.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)fromXml.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)fromXml.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)fromXml.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)fromXml.getGlobals().size());
        Assert.assertEquals((long)0L, (long)fromXml.getTaskEventListeners().size());
        Assert.assertEquals((long)1L, (long)fromXml.getWorkItemHandlers().size());
        Assert.assertEquals((long)1L, (long)fromXml.getRequiredRoles().size());
    }

    @Test
    public void testCreateDeploymentDescriptorWithPrefixedRoles() {
        DeploymentDescriptorImpl descriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        descriptor.setAuditMode(AuditMode.JMS);
        descriptor.setEnvironmentEntries(null);
        ArrayList<ObjectModel> marshallingStrategies = new ArrayList<ObjectModel>();
        marshallingStrategies.add(new ObjectModel("org.jbpm.testCustomStrategy", new Object[]{new ObjectModel("java.lang.String", new Object[]{"param1"}), "param2"}));
        descriptor.setMarshallingStrategies(marshallingStrategies);
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("view:managers");
        roles.add("execute:experts");
        roles.add("all:everyone");
        roles.add("employees");
        descriptor.setRequiredRoles(roles);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)descriptor.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JMS, (Object)descriptor.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)descriptor.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)descriptor.getRuntimeStrategy());
        Assert.assertEquals((long)1L, (long)descriptor.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)descriptor.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)descriptor.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getGlobals().size());
        Assert.assertEquals((long)0L, (long)descriptor.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)descriptor.getWorkItemHandlers().size());
        Assert.assertEquals((long)4L, (long)descriptor.getRequiredRoles().size());
        List toVerify = descriptor.getRequiredRoles();
        Assert.assertEquals((long)4L, (long)toVerify.size());
        Assert.assertTrue((boolean)toVerify.contains("view:managers"));
        Assert.assertTrue((boolean)toVerify.contains("execute:experts"));
        Assert.assertTrue((boolean)toVerify.contains("all:everyone"));
        Assert.assertTrue((boolean)toVerify.contains("employees"));
        toVerify = descriptor.getRequiredRoles("all");
        Assert.assertEquals((long)4L, (long)toVerify.size());
        Assert.assertTrue((boolean)toVerify.contains("managers"));
        Assert.assertTrue((boolean)toVerify.contains("experts"));
        Assert.assertTrue((boolean)toVerify.contains("everyone"));
        Assert.assertTrue((boolean)toVerify.contains("employees"));
        toVerify = descriptor.getRequiredRoles("execute");
        Assert.assertEquals((long)2L, (long)toVerify.size());
        Assert.assertTrue((boolean)toVerify.contains("experts"));
        Assert.assertTrue((boolean)toVerify.contains("employees"));
        toVerify = descriptor.getRequiredRoles("view");
        Assert.assertEquals((long)2L, (long)toVerify.size());
        Assert.assertTrue((boolean)toVerify.contains("managers"));
        Assert.assertTrue((boolean)toVerify.contains("employees"));
    }

    @Test
    public void testWriteDeploymentDescriptorXmlWithTransientElements() {
        DeploymentDescriptorImpl descriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        descriptor.getBuilder().addMarshalingStrategy((ObjectModel)new TransientObjectModel("org.jbpm.testCustomStrategy", new Object[]{new ObjectModel("java.lang.String", new Object[]{"param1"}), "param2"})).addWorkItemHandler((NamedObjectModel)new TransientNamedObjectModel("mvel", "Log", "new org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler()", new Object[0])).addRequiredRole("experts");
        String deploymentDescriptorXml = descriptor.toXml();
        Assert.assertNotNull((Object)deploymentDescriptorXml);
        logger.info(deploymentDescriptorXml);
        ByteArrayInputStream stream = new ByteArrayInputStream(deploymentDescriptorXml.getBytes());
        DeploymentDescriptor fromXml = DeploymentDescriptorIO.fromXml((InputStream)stream);
        Assert.assertNotNull((Object)fromXml);
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)fromXml.getPersistenceUnit());
        Assert.assertEquals((Object)"org.jbpm.domain", (Object)fromXml.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)fromXml.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)fromXml.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)fromXml.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)fromXml.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)fromXml.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)fromXml.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)fromXml.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)fromXml.getGlobals().size());
        Assert.assertEquals((long)0L, (long)fromXml.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)fromXml.getWorkItemHandlers().size());
        Assert.assertEquals((long)1L, (long)fromXml.getRequiredRoles().size());
    }

    @Test
    public void testEmptyDeploymentDescriptor() {
        DeploymentDescriptorImpl descriptor = new DeploymentDescriptorImpl("org.jbpm.domain");
        descriptor.getBuilder().addMarshalingStrategy(new ObjectModel("org.jbpm.testCustomStrategy", new Object[]{new ObjectModel("java.lang.String", new Object[]{"param1"}), "param2"})).addRequiredRole("experts");
        Assert.assertFalse((boolean)descriptor.isEmpty());
        InputStream input = this.getClass().getResourceAsStream("/deployment/empty-descriptor.xml");
        DeploymentDescriptor fromXml = DeploymentDescriptorIO.fromXml((InputStream)input);
        Assert.assertNotNull((Object)fromXml);
        Assert.assertTrue((boolean)((DeploymentDescriptorImpl)fromXml).isEmpty());
        Assert.assertNull((Object)fromXml.getPersistenceUnit());
        Assert.assertNull((Object)fromXml.getAuditPersistenceUnit());
        Assert.assertEquals((Object)AuditMode.JPA, (Object)fromXml.getAuditMode());
        Assert.assertEquals((Object)PersistenceMode.JPA, (Object)fromXml.getPersistenceMode());
        Assert.assertEquals((Object)RuntimeStrategy.SINGLETON, (Object)fromXml.getRuntimeStrategy());
        Assert.assertEquals((long)0L, (long)fromXml.getMarshallingStrategies().size());
        Assert.assertEquals((long)0L, (long)fromXml.getConfiguration().size());
        Assert.assertEquals((long)0L, (long)fromXml.getEnvironmentEntries().size());
        Assert.assertEquals((long)0L, (long)fromXml.getEventListeners().size());
        Assert.assertEquals((long)0L, (long)fromXml.getGlobals().size());
        Assert.assertEquals((long)0L, (long)fromXml.getTaskEventListeners().size());
        Assert.assertEquals((long)0L, (long)fromXml.getWorkItemHandlers().size());
        Assert.assertEquals((long)0L, (long)fromXml.getRequiredRoles().size());
    }
}

