/*
 * Decompiled with CFR 0.152.
 */
package org.kie.karaf.itest.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.junit.Assert;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.karaf.itest.util.FileManager;
import org.kie.scanner.KieMavenRepository;

public class KieScannerTestUtils {
    private final FileManager fileManager = new FileManager();

    public void setUp() {
        this.fileManager.setUp();
    }

    public void tearDown() {
        this.fileManager.tearDown();
    }

    public void createAndInstallKJar(ReleaseId releaseId, String ... rules) {
        KieServices ks = KieServices.Factory.get();
        try {
            InternalKieModule kJar1 = this.createKieJar(ks, releaseId, rules);
            ks.newKieContainer(releaseId);
            KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
            repository.installArtifact((AFReleaseId)releaseId, kJar1, this.createKPom(this.fileManager, releaseId, new ReleaseId[0]));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to install artifact " + releaseId, e);
        }
    }

    public void createAndInstallKJarWithDependencies(ReleaseId releaseId, String rule, ReleaseId ... dependencies) {
        KieServices ks = KieServices.Factory.get();
        try {
            InternalKieModule kJar1 = this.createKieJarWithDependencies(ks, releaseId, true, rule, dependencies);
            ks.newKieContainer(releaseId);
            KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
            repository.installArtifact((AFReleaseId)releaseId, kJar1, this.createKPom(this.fileManager, releaseId, new ReleaseId[0]));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to install artifact " + releaseId, e);
        }
    }

    protected InternalKieModule createKieJar(KieServices ks, ReleaseId releaseId, boolean isdefault, String ... rules) throws IOException {
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks, isdefault);
        kfs.writePomXML(this.getPom(releaseId, new ReleaseId[0]));
        for (String rule : rules) {
            String file = "org/test/" + rule + ".drl";
            kfs.write("src/main/resources/KBase1/" + file, this.createDRL(rule));
        }
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assert.assertTrue((boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty());
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    protected InternalKieModule createKieJarWithDependencies(KieServices ks, ReleaseId releaseId, boolean isdefault, String rule, ReleaseId ... dependencies) throws IOException {
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks, isdefault);
        kfs.writePomXML(this.getPom(releaseId, dependencies));
        String file = "org/test/rules.drl";
        InputStream ruleStream = KieScannerTestUtils.class.getResourceAsStream(rule);
        String ruleContent = new BufferedReader(new InputStreamReader(ruleStream)).lines().collect(Collectors.joining("\n"));
        kfs.write("src/main/resources/KBase1/" + file, ruleContent);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assert.assertTrue((boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty());
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    protected InternalKieModule createKieJar(KieServices ks, ReleaseId releaseId, String pomXml, boolean isdefault, String ... rules) throws IOException {
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks, isdefault);
        kfs.writePomXML(pomXml);
        for (String rule : rules) {
            String file = "org/test/" + rule + ".drl";
            kfs.write("src/main/resources/KBase1/" + file, this.createDRL(rule));
        }
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assert.assertTrue((boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty());
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    protected InternalKieModule createKieJar(KieServices ks, ReleaseId releaseId, String ... rules) throws IOException {
        return this.createKieJar(ks, releaseId, false, rules);
    }

    protected InternalKieModule createKieJarWithClass(KieServices ks, ReleaseId releaseId, boolean useTypeDeclaration, int value, int factor, ReleaseId ... dependencies) throws IOException {
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks, false);
        kfs.writePomXML(this.getPom(releaseId, dependencies));
        if (useTypeDeclaration) {
            kfs.write("src/main/resources/KBase1/rule1.drl", this.createDRLWithTypeDeclaration(value, factor));
        } else {
            kfs.write("src/main/resources/KBase1/rule1.drl", this.createDRLForJavaSource(value)).write("src/main/java/org/kie/test/Bean.java", this.createJavaSource(factor));
        }
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assert.assertTrue((boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty());
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    protected KieFileSystem createKieFileSystemWithKProject(KieServices ks) {
        return this.createKieFileSystemWithKProject(ks, false);
    }

    protected KieFileSystem createKieFileSystemWithKProject(KieServices ks, boolean isdefault) {
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel("KBase1").setDefault(isdefault).setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM);
        kieBaseModel1.newKieSessionModel("KSession1").setDefault(isdefault).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"realtime"));
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML());
        return kfs;
    }

    protected String getPom(ReleaseId releaseId, ReleaseId ... dependencies) {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + releaseId.getGroupId() + "</groupId>\n  <artifactId>" + releaseId.getArtifactId() + "</artifactId>\n  <version>" + releaseId.getVersion() + "</version>\n\n";
        if (dependencies != null && dependencies.length > 0) {
            pom = pom + "<dependencies>\n";
            for (ReleaseId dep : dependencies) {
                pom = pom + "<dependency>\n";
                pom = pom + "  <groupId>" + dep.getGroupId() + "</groupId>\n";
                pom = pom + "  <artifactId>" + dep.getArtifactId() + "</artifactId>\n";
                pom = pom + "  <version>" + dep.getVersion() + "</version>\n";
                pom = pom + "</dependency>\n";
            }
            pom = pom + "</dependencies>\n";
        }
        pom = pom + "</project>";
        return pom;
    }

    protected String createDRL(String ruleName) {
        return "package org.kie.test\nglobal java.util.List list\nrule " + ruleName + "\nwhen\nthen\nlist.add( drools.getRule().getName() );\nend\n";
    }

    private String createJavaSource(int factor) {
        return "package org.kie.test;\nimport org.kie.api.definition.type.Role;\n@Role(Role.Type.EVENT)\npublic class Bean {\n   private final int value;\n   public Bean(int value) {\n       this.value = value;\n   }\n   public int getValue() {\n       return value * " + factor + ";\n   }\n}";
    }

    private String createDRLForJavaSource(int value) {
        return "package org.kie.test\nglobal java.util.List list\nrule Init salience 100\nwhen\nthen\ninsert( new Bean(" + value + ") );\nend\nrule R1\nwhen\n   $b : Bean( value > 0 )\nthen\n   list.add( $b.getValue() );\nend\n";
    }

    protected String createDRLWithTypeDeclaration(int value, int factor) {
        return "package org.kie.test\n" + this.getDRLWithType() + this.getDRLWithRules(value, factor);
    }

    protected String getDRLWithType() {
        return "declare Bean @role(event)\n   value : int\nend\n";
    }

    protected String getDRLWithRules(int value, int factor) {
        return "global java.util.List list\nrule Init salience 100\nwhen\nthen\ninsert( new Bean(" + value + ") );\nend\nrule R1\nwhen\n   $b : Bean()\nthen\n   list.add( $b.getValue() * " + factor + " );\nend\n";
    }

    public static byte[] createKJar(KieServices ks, ReleaseId releaseId, String pom, String ... drls) {
        KieFileSystem kfs = ks.newKieFileSystem();
        if (pom != null) {
            kfs.write("pom.xml", pom);
        } else {
            kfs.generateAndWritePomXML(releaseId);
        }
        for (int i = 0; i < drls.length; ++i) {
            if (drls[i] == null) continue;
            kfs.write("src/main/resources/r" + i + ".drl", drls[i]);
        }
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            for (Message result : kb.getResults().getMessages()) {
                System.out.println(result.getText());
            }
            return null;
        }
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule(releaseId);
        byte[] jar = kieModule.getBytes();
        return jar;
    }

    public static KieModule deployJar(KieServices ks, byte[] jar) {
        Resource jarRes = ks.getResources().newByteArrayResource(jar);
        KieModule km = ks.getRepository().addKieModule(jarRes, new Resource[0]);
        return km;
    }

    protected File createKPom(FileManager fileManager, ReleaseId releaseId, ReleaseId ... dependencies) throws IOException {
        File pomFile = fileManager.newFile("pom.xml");
        fileManager.write(pomFile, this.getPom(releaseId, dependencies));
        return pomFile;
    }

    public void checkKSession(boolean dispose, KieSession ksession, Object ... results) {
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        if (dispose) {
            ksession.dispose();
        }
        Assert.assertEquals((long)results.length, (long)list.size());
        for (Object result : results) {
            Assert.assertTrue((String)String.format("Expected to contain: %s, got: %s", result, Arrays.toString(list.toArray())), (boolean)list.contains(result));
        }
    }
}

