/*
 * Decompiled with CFR 0.152.
 */
package org.kie.karaf.itest;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import org.h2.tools.Server;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.task.TaskService;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.karaf.itest.AbstractKieSpringKarafIntegrationTest;
import org.kie.karaf.itest.KieSpringDependencyKarafIntegrationTest;
import org.kie.karaf.itest.SimpleKieSpringKarafIntegrationTest;
import org.kie.karaf.itest.model.Person;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;
import org.ops4j.pax.exam.util.Filter;
import org.ops4j.pax.swissbox.core.ContextClassLoaderUtils;
import org.ops4j.pax.tinybundles.core.TinyBundles;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;

@RunWith(value=PaxExam.class)
@ExamReactorStrategy(value={PerClass.class})
public class KieSpringjBPMPersistenceKarafIntegrationTest
extends AbstractKieSpringKarafIntegrationTest {
    private static final transient Logger logger = LoggerFactory.getLogger(KieSpringjBPMPersistenceKarafIntegrationTest.class);
    private static final String SPRING_XML_LOCATION = "/org/kie/karaf/itest/kie-beans-persistence.xml";
    private static final String SPRING_APPLICATION_CONTEXT_ID = "." + ApplicationContext.class.getName();
    private static final String DRL_LOCATION = "/drl_kiesample/Hal1.drl";
    @Inject
    @Filter(value="(osgi.blueprint.container.symbolicname=Test-Kie-Spring-Bundle)", timeout=120000L)
    private BlueprintContainer container;

    @Before
    public void init() {
        this.applicationContext = (ConfigurableApplicationContext)this.container.getComponentInstance(SPRING_APPLICATION_CONTEXT_ID);
        Assert.assertNotNull((String)"Should have created a valid spring context", (Object)this.applicationContext);
    }

    @Test
    public void testJbpmRuntimeManager() {
        this.refresh();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newEmptyBuilder().addAsset(KieServices.Factory.get().getResources().newClassPathResource("Evaluation.bpmn", this.getClass().getClassLoader()), ResourceType.BPMN2).get();
        RuntimeManager runtimeManager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        KieSession ksession = runtimeManager.getRuntimeEngine(EmptyContext.get()).getKieSession();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        logger.info("Start process Evaluation (bpmn2)");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "krisv");
        params.put("reason", "Yearly performance evaluation");
        ProcessInstance processInstance = ksession.startProcess("com.sample.evaluation", params);
        logger.info("Started process instance " + processInstance.getId());
    }

    @Test
    public void testJbpmRuntimeManagerWithPersistence() throws Exception {
        this.refresh();
        final Properties props = new Properties();
        props.setProperty("krisv", "IT");
        props.setProperty("john", "HR");
        props.setProperty("mary", "PM");
        final EntityManagerFactory emf = (EntityManagerFactory)this.applicationContext.getBean("myEmf");
        final PlatformTransactionManager txManager = (PlatformTransactionManager)this.applicationContext.getBean("txManager");
        ContextClassLoaderUtils.doWithClassLoader((ClassLoader)this.getClass().getClassLoader(), (Callable)new Callable<Object>(){

            @Override
            public Object call() {
                RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)emf).addEnvironmentEntry("org.kie.transaction.TransactionManager", (Object)txManager).addAsset(KieServices.Factory.get().getResources().newClassPathResource("Evaluation.bpmn", this.getClass().getClassLoader()), ResourceType.BPMN2).userGroupCallback((UserGroupCallback)new JBossUserGroupCallbackImpl(props)).get();
                RuntimeManager runtimeManager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
                RuntimeEngine runtimeEngine = runtimeManager.getRuntimeEngine(EmptyContext.get());
                KieSession ksession = runtimeEngine.getKieSession();
                TaskService taskService = runtimeEngine.getTaskService();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("employee", "krisv");
                params.put("reason", "Yearly performance evaluation");
                ProcessInstance processInstance = ksession.startProcess("com.sample.evaluation", params);
                System.out.println("Process instance " + processInstance.getId() + " started ...");
                ProcessInstance pi = ksession.getProcessInstance(processInstance.getId());
                System.out.println(pi);
                List tasks = taskService.getTasksAssignedAsPotentialOwner("krisv", "en-UK");
                TaskSummary task = (TaskSummary)tasks.get(0);
                System.out.println("'krisv' completing task " + task.getName() + ": " + task.getDescription());
                taskService.start(task.getId().longValue(), "krisv");
                Map vars = taskService.getTaskContent(task.getId().longValue());
                HashMap<String, String> results = new HashMap<String, String>();
                results.put("performance", "exceeding");
                taskService.complete(task.getId().longValue(), "krisv", results);
                tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
                task = (TaskSummary)tasks.get(0);
                System.out.println("'john' completing task " + task.getName() + ": " + task.getDescription());
                taskService.claim(task.getId().longValue(), "john");
                taskService.start(task.getId().longValue(), "john");
                results = new HashMap();
                results.put("performance", "acceptable");
                taskService.complete(task.getId().longValue(), "john", results);
                tasks = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
                task = (TaskSummary)tasks.get(0);
                System.out.println("'mary' completing task " + task.getName() + ": " + task.getDescription());
                taskService.claim(task.getId().longValue(), "mary");
                taskService.start(task.getId().longValue(), "mary");
                results = new HashMap();
                results.put("performance", "outstanding");
                taskService.complete(task.getId().longValue(), "mary", results);
                System.out.println("Process instance completed");
                runtimeManager.disposeRuntimeEngine(runtimeEngine);
                runtimeManager.close();
                return null;
            }
        });
    }

    public static Server startH2Server() {
        try {
            Server server = Server.createTcpServer((String[])new String[0]);
            server.start();
            return server;
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not start H2 server", t);
        }
    }

    @Configuration
    public static Option[] configure() {
        Server server = KieSpringjBPMPersistenceKarafIntegrationTest.startH2Server();
        String jdbcDriverPath = System.getProperty("jdbc.driver.path");
        List<Option> configurationOptions = KieSpringjBPMPersistenceKarafIntegrationTest.getDefaultOptions();
        if (jdbcDriverPath != null && !"".equals(jdbcDriverPath)) {
            try {
                configurationOptions.add((Option)CoreOptions.wrappedBundle((String)new File(jdbcDriverPath).toURI().toURL().toString()));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Error parsing jdbc driver path", e);
            }
        }
        return configurationOptions.toArray(new Option[0]);
    }

    private static List<Option> getDefaultOptions() {
        ArrayList<Option> options = new ArrayList<Option>();
        options.add(KieSpringjBPMPersistenceKarafIntegrationTest.getKarafDistributionOption());
        options.add((Option)KarafDistributionOption.configureConsole().ignoreLocalConsole());
        options.add(KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.WARN));
        options.add(KieSpringjBPMPersistenceKarafIntegrationTest.loadKieFeatures("jbpm-spring-persistent"));
        options.add((Option)KarafDistributionOption.features((UrlReference)KieSpringjBPMPersistenceKarafIntegrationTest.getFeaturesUrl("org.apache.karaf.features", "spring-legacy", KieSpringjBPMPersistenceKarafIntegrationTest.getKarafVersion()), (String[])new String[]{"aries-blueprint-spring"}));
        options.add((Option)CoreOptions.streamBundle((InputStream)TinyBundles.bundle().set("Bundle-ManifestVersion", "2").add(Person.class).add("META-INF/spring/kie-beans-persistence.xml", SimpleKieSpringKarafIntegrationTest.class.getResource(SPRING_XML_LOCATION)).add("META-INF/persistence.xml", SimpleKieSpringKarafIntegrationTest.class.getResource("/META-INF/persistence.xml")).add("drl_kiesample/Hal1.drl", KieSpringDependencyKarafIntegrationTest.class.getResource(DRL_LOCATION)).add("META-INF/JBPMorm.xml", SimpleKieSpringKarafIntegrationTest.class.getResource("/META-INF/JBPMorm.xml")).add("META-INF/TaskAuditorm.xml", SimpleKieSpringKarafIntegrationTest.class.getResource("/META-INF/TaskAuditorm.xml")).add("META-INF/Taskorm.xml", SimpleKieSpringKarafIntegrationTest.class.getResource("/META-INF/Taskorm.xml")).set("DynamicImport-Package", "*").set("Bundle-SymbolicName", "Test-Kie-Spring-Bundle").build()).start());
        return options;
    }
}

