/*
 * Decompiled with CFR 0.152.
 */
package org.kie.karaf.itest;

import org.drools.decisiontable.ExternalSpreadsheetCompiler;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.karaf.itest.AbstractKarafIntegrationTest;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;

@RunWith(value=PaxExam.class)
@ExamReactorStrategy(value={PerClass.class})
public class DecisionTablesIntegrationTest
extends AbstractKarafIntegrationTest {
    private static final String SIMPLE_XLS = "/decisiontables/data/MultiSheetDST.xls";
    private static final String SIMPLE_TEMPLATE = "/decisiontables/templates/test_template1.drl";
    private ClassLoader origTCCL;

    @Before
    public void setTCCL() {
        this.origTCCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Object.class.getClassLoader());
    }

    @After
    public void restoreTCCL() {
        Thread.currentThread().setContextClassLoader(this.origTCCL);
    }

    @Test
    public void testBasic() throws Exception {
        ClassLoader bundleClassloader = this.getClass().getClassLoader();
        ExternalSpreadsheetCompiler converter = new ExternalSpreadsheetCompiler();
        String drl = converter.compile(bundleClassloader.getResourceAsStream(SIMPLE_XLS), bundleClassloader.getResourceAsStream(SIMPLE_TEMPLATE), 11, 2);
    }

    @Configuration
    public static Option[] configure() {
        return new Option[]{DecisionTablesIntegrationTest.getKarafDistributionOption(), KarafDistributionOption.configureConsole().ignoreLocalConsole(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.WARN), DecisionTablesIntegrationTest.loadKieFeatures("drools-decisiontable")};
    }
}

