/*
 * Decompiled with CFR 0.152.
 */
package org.kie.karaf.itest;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.kie.karaf.itest.AbstractKieSpringKarafIntegrationTest;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.MavenUtils;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.karaf.options.ConfigurationPointer;
import org.ops4j.pax.exam.karaf.options.KarafDistributionBaseConfigurationOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.configs.CustomProperties;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.options.MavenArtifactProvisionOption;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.ops4j.pax.exam.options.UrlReference;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKarafIntegrationTest {
    public static final String PROP_KARAF_DISTRIBUTION_FILE = "karaf.dist.file";
    public static final String PROP_KARAF_VERSION = "karaf.version";
    public static final String PROP_CXF_VERSION = "cxf.version";
    public static final String PROP_CAMEL_VERSION = "camel.version";
    public static final String PROP_KARAF_MAXPERMSIZE = "karaf.maxpermsize";
    public static final String PROP_KEEP_RUNTIME_FOLDER = "karaf.keep.runtime.folder";
    private static final String KARAF_GROUP_ID = "org.apache.karaf";
    private static final String KARAF_ARTIFACT_ID = "apache-karaf";
    public static final String PROP_KARAF_FRAMEWORK = "karaf.osgi.framework";
    public static final String PROP_ADDITIONAL_MAVEN_REPOS = "karaf.maven.repos";
    public static final String SYSTEM_PROP_MAVEN_CUSTOM_SETTINGS = "kie.maven.settings.custom";
    public static final String TEST_PROPERTIES_FILE = "test.properties";
    public static final String MAVEN_REPO_LOCAL_PROPERTY = "maven.repo.local";
    public static final String KIE_MAVEN_SETTINGS_CUSTOM_PROPERTY = "kie.maven.settings.custom";
    private static final transient Logger logger = LoggerFactory.getLogger(AbstractKarafIntegrationTest.class);
    protected static final String KIE_VERSION;
    @Inject
    protected BundleContext bundleContext;

    protected Bundle getInstalledBundle(String symbolicName) {
        for (Bundle b : this.bundleContext.getBundles()) {
            if (!b.getSymbolicName().equals(symbolicName)) continue;
            return b;
        }
        for (Bundle b : this.bundleContext.getBundles()) {
            logger.warn("Bundle: " + b.getSymbolicName());
        }
        throw new RuntimeException("Bundle " + symbolicName + " does not exist");
    }

    protected static String getKarafVersion() {
        String karafVersion = System.getProperty(PROP_KARAF_VERSION);
        if (karafVersion == null) {
            if (System.getProperty(PROP_KARAF_DISTRIBUTION_FILE) != null) {
                throw new RuntimeException("When you are running against custom container it is necessary to define Karaf version by defining system property karaf.version.");
            }
            MavenUrlReference.VersionResolver versionResolver = MavenUtils.asInProject();
            karafVersion = versionResolver.getVersion(KARAF_GROUP_ID, KARAF_ARTIFACT_ID);
        }
        return karafVersion;
    }

    protected static String getCxfVersion() {
        return System.getProperty(PROP_CXF_VERSION);
    }

    protected static String getCamelVersion() {
        return System.getProperty(PROP_CAMEL_VERSION);
    }

    public static Option getKarafDistributionOption() {
        ArrayList<Object> options = new ArrayList<Object>();
        String karafVersion = AbstractKarafIntegrationTest.getKarafVersion();
        String cxfVersion = AbstractKarafIntegrationTest.getCxfVersion();
        String camelVersion = AbstractKarafIntegrationTest.getCamelVersion();
        logger.info("*** The karaf version is " + karafVersion + " ***");
        logger.info("*** The cxf version is " + cxfVersion + " ***");
        logger.info("*** The camel version is " + camelVersion + " ***");
        KarafDistributionBaseConfigurationOption karafConfiguration = KarafDistributionOption.karafDistributionConfiguration();
        if (System.getProperty(PROP_KARAF_DISTRIBUTION_FILE) == null) {
            karafConfiguration.frameworkUrl((MavenUrlReference)CoreOptions.maven().groupId(KARAF_GROUP_ID).artifactId(KARAF_ARTIFACT_ID).type("tar.gz").versionAsInProject());
        } else {
            File fuseDistributionFile = new File(System.getProperty(PROP_KARAF_DISTRIBUTION_FILE));
            karafConfiguration.frameworkUrl("file:" + fuseDistributionFile.getAbsolutePath());
        }
        karafConfiguration.karafVersion(karafVersion).name("Apache Karaf").useDeployFolder(false).unpackDirectory(new File("target/paxexam/unpack/"));
        options.add(karafConfiguration);
        if (System.getProperty("additional.features.url") != null) {
            options.add(KarafDistributionOption.editConfigurationFileExtend((String)"etc/org.apache.karaf.features.cfg", (String)"featuresRepositories", (Object)System.getProperty("additional.features.url")));
        }
        if (System.getProperty(PROP_KARAF_MAXPERMSIZE) != null) {
            options.add(CoreOptions.vmOption((String)("-XX:MaxPermSize=" + System.getProperty(PROP_KARAF_MAXPERMSIZE))));
        }
        if (System.getProperty(PROP_KEEP_RUNTIME_FOLDER) != null) {
            options.add(KarafDistributionOption.keepRuntimeFolder());
        }
        options.add(AbstractKarafIntegrationTest.localMavenRepoOption());
        options.add(CoreOptions.vmOption((String)"-Dkaraf.log=${karaf.data}/log"));
        String additionalMavenRepositories = "";
        if (System.getProperty(PROP_ADDITIONAL_MAVEN_REPOS) != null) {
            additionalMavenRepositories = "," + System.getProperty(PROP_ADDITIONAL_MAVEN_REPOS);
        }
        options.add(KarafDistributionOption.editConfigurationFilePut((String)"etc/org.ops4j.pax.url.mvn.cfg", (String)"org.ops4j.pax.url.mvn.repositories", (Object)("https://repo1.maven.org/maven2@id=central,https://repository.jboss.org/nexus/content/groups/public@snapshots@id=jboss-public" + additionalMavenRepositories)));
        options.add(KarafDistributionOption.editConfigurationFilePut((String)"etc/system.properties", (String)"patching.disabled", (Object)"true"));
        if (!"features-fuse".equals(System.getProperty("kie.features.classifier"))) {
            options.add(KarafDistributionOption.editConfigurationFilePut((String)"etc/startup.properties", (String)"mvn:org.ops4j.pax.url/pax-url-wrap/2.6.10/jar/uber", (Object)"5"));
            options.add(KarafDistributionOption.editConfigurationFileExtend((String)"etc/org.apache.karaf.features.cfg", (String)"featuresRepositories", (Object)("mvn:org.apache.karaf.features/spring/" + karafVersion + "/xml/features")));
            options.add(KarafDistributionOption.editConfigurationFileExtend((String)"etc/org.apache.karaf.features.cfg", (String)"featuresRepositories", (Object)("mvn:org.apache.cxf.karaf/apache-cxf/" + cxfVersion + "/xml/features")));
            options.add(KarafDistributionOption.editConfigurationFileExtend((String)"etc/org.apache.karaf.features.cfg", (String)"featuresRepositories", (Object)("mvn:org.apache.camel.karaf/apache-camel/" + camelVersion + "/xml/features")));
            options.add(KarafDistributionOption.replaceConfigurationFile((String)"etc/org.apache.karaf.features.xml", (File)new File("target/test-classes/org.apache.karaf.features.xml")));
            options.add(KarafDistributionOption.editConfigurationFileExtend((String)"etc/org.apache.karaf.features.cfg", (String)"featuresBoot", (Object)("aries-blueprint/" + karafVersion)));
            options.add(KarafDistributionOption.editConfigurationFileExtend((String)"etc/org.apache.karaf.features.cfg", (String)"featuresBoot", (Object)"pax-http-jetty"));
            options.add(KarafDistributionOption.editConfigurationFileExtend((String)"etc/org.apache.karaf.features.cfg", (String)"featuresBoot", (Object)"cxf-http"));
            options.add(KarafDistributionOption.editConfigurationFileExtend((String)"etc/org.apache.karaf.features.cfg", (String)"featuresBoot", (Object)"servlet-api-kie"));
            options.add(KarafDistributionOption.editConfigurationFilePut((String)"etc/org.apache.karaf.features.repos.cfg", (String)"cxf", (Object)("mvn:org.apache.cxf.karaf/apache-cxf/" + cxfVersion + "/xml/features")));
            options.add(KarafDistributionOption.editConfigurationFilePut((String)"etc/org.apache.karaf.features.repos.cfg", (String)"camel", (Object)("mvn:org.apache.camel.karaf/apache-camel/" + camelVersion + "/xml/features")));
        }
        if (System.getProperty(PROP_KARAF_FRAMEWORK) != null) {
            options.add(KarafDistributionOption.editConfigurationFilePut((ConfigurationPointer)CustomProperties.KARAF_FRAMEWORK, (Object)System.getProperty(PROP_KARAF_FRAMEWORK)));
        }
        options.add(KarafDistributionOption.keepRuntimeFolder());
        return new DefaultCompositeOption(options.toArray(new Option[1]));
    }

    public static Option localMavenRepoOption() {
        DefaultCompositeOption compositeOption = new DefaultCompositeOption();
        if (System.getProperties().containsKey(MAVEN_REPO_LOCAL_PROPERTY)) {
            String localRepo = System.getProperty(MAVEN_REPO_LOCAL_PROPERTY);
            compositeOption.add(new Option[]{KarafDistributionOption.editConfigurationFilePut((String)"etc/org.ops4j.pax.url.mvn.cfg", (String)"org.ops4j.pax.url.mvn.localRepository", (Object)new File(localRepo).getAbsolutePath())});
            System.out.println("Using alternative local Maven repository in " + localRepo);
            logger.info("Using alternative local Maven repository in {}.", (Object)new File(localRepo).getAbsolutePath());
        }
        if (System.getProperties().containsKey("kie.maven.settings.custom")) {
            String kieMavenSettingsCustom = System.getProperty("kie.maven.settings.custom");
            compositeOption.add(new Option[]{CoreOptions.systemProperty((String)"kie.maven.settings.custom").value(kieMavenSettingsCustom)});
            System.out.println("Using custom Maven settings file " + kieMavenSettingsCustom);
            logger.info("Using custom Maven settings file {}.", (Object)kieMavenSettingsCustom);
        }
        return compositeOption;
    }

    public static MavenArtifactProvisionOption getFeaturesUrl(String groupId, String artifactId, String version) {
        String classifier = "features";
        if (System.getProperty("kie.features.classifier") != null && "kie-karaf-features".equals(artifactId)) {
            classifier = System.getProperty("kie.features.classifier");
        }
        MavenArtifactProvisionOption mapo = CoreOptions.mavenBundle().groupId(groupId).artifactId(artifactId);
        mapo.type("xml");
        mapo.classifier(classifier);
        if (version == null) {
            mapo.versionAsInProject();
        } else {
            mapo.version(version);
        }
        logger.info("Features URL: " + mapo.getURL());
        return mapo;
    }

    public static Option loadKieFeaturesRepo() {
        String classifier = "features";
        if (System.getProperty("kie.features.classifier") != null) {
            classifier = System.getProperty("kie.features.classifier");
        }
        return KarafDistributionOption.features((String)CoreOptions.maven().groupId("org.kie").artifactId("kie-karaf-features").type("xml").classifier(classifier).versionAsInProject().getURL(), (String[])new String[0]);
    }

    public static Option loadKieFeatures(String ... features) {
        MavenArtifactProvisionOption featuresUrl = AbstractKarafIntegrationTest.getFeaturesUrl("org.kie", "kie-karaf-features", KIE_VERSION);
        return KarafDistributionOption.features((UrlReference)featuresUrl, (String[])features);
    }

    public static Option loadKieFeatures(List<String> features) {
        return AbstractKarafIntegrationTest.loadKieFeatures(features.toArray(new String[features.size()]));
    }

    static {
        Properties testProps = new Properties();
        try {
            testProps.load(AbstractKieSpringKarafIntegrationTest.class.getResourceAsStream("/test.properties"));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to initialize KIE_VERSION property: " + e.getMessage(), e);
        }
        KIE_VERSION = testProps.getProperty("project.version");
        logger.info("KIE Project Version : " + KIE_VERSION);
    }
}

