/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.drools.ancompiler.CompiledNetworkSource;
import org.drools.ancompiler.ObjectTypeNodeCompiler;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.Rete;
import org.drools.modelcompiler.CanonicalKieModule;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.maven.plugin.AbstractDMNValidationAwareMojo;
import org.kie.maven.plugin.ExecModelMode;

@Mojo(name="generateANC", requiresDependencyResolution=ResolutionScope.NONE, defaultPhase=LifecyclePhase.COMPILE)
public class GenerateANCMojo
extends AbstractDMNValidationAwareMojo {
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession mavenSession;
    @Parameter(required=true, defaultValue="${project.build.directory}")
    private File targetDirectory;
    @Parameter(required=true, defaultValue="${project.basedir}")
    private File projectDir;
    @Parameter(required=true, defaultValue="${project.build.testSourceDirectory}")
    private File testDir;
    @Parameter
    private Map<String, String> properties;
    @Parameter(required=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    private static final String ALPHA_NETWORK_COMPILER_PATH = "/generated-sources/alpha-network-compiler/main/java";

    public void execute() throws MojoExecutionException {
        boolean ancParameterEnabled = ExecModelMode.ancEnabled(this.getGenerateModelOption());
        boolean modelCompilerInClassPath = ExecModelMode.isModelCompilerInClassPath(this.project.getDependencies());
        if (ancParameterEnabled && modelCompilerInClassPath) {
            this.generateANC();
        } else if (ancParameterEnabled) {
            this.getLog().warn((CharSequence)"You're trying to build rule assets in a project from an executable rule model, but you did not provide the required dependency on the project classpath.\nTo enable executable rule models for your project, add the `drools-model-compiler` dependency in the `pom.xml` file of your project.\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateANC() throws MojoExecutionException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            HashSet<URL> urls = new HashSet<URL>();
            for (String element : this.project.getCompileClasspathElements()) {
                urls.add(new File(element).toURI().toURL());
            }
            this.project.setArtifactFilter((ArtifactFilter)new CumulativeScopeArtifactFilter(Arrays.asList("compile", "runtime")));
            for (Object artifact : this.project.getArtifacts()) {
                File file = artifact.getFile();
                if (file == null) continue;
                urls.add(file.toURI().toURL());
            }
            urls.add(this.outputDirectory.toURI().toURL());
            URLClassLoader projectClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]), ((Object)((Object)this)).getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(projectClassLoader);
        }
        catch (MalformedURLException | DependencyResolutionRequiredException e) {
            throw new RuntimeException(e);
        }
        try {
            this.setSystemProperties(this.properties);
            KieServices ks = KieServices.Factory.get();
            KieContainer kieContainer = ks.newKieContainer((ReleaseId)new ReleaseIdImpl(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion()));
            for (String kbase : kieContainer.getKieBaseNames()) {
                InternalKnowledgeBase kieBase = (InternalKnowledgeBase)kieContainer.getKieBase(kbase);
                List ancSourceFiles = ObjectTypeNodeCompiler.compiledNetworkSources((Rete)kieBase.getRete());
                this.getLog().info((CharSequence)String.format("Found %d generated files in Knowledge Base %s", ancSourceFiles.size(), kbase));
                String alphaNetworkCompilerPath = ALPHA_NETWORK_COMPILER_PATH;
                String newCompileSourceRoot = this.targetDirectory.getPath() + ALPHA_NETWORK_COMPILER_PATH;
                this.project.addCompileSourceRoot(newCompileSourceRoot);
                for (CompiledNetworkSource generatedFile : ancSourceFiles) {
                    Path newFile = Paths.get(this.targetDirectory.getPath(), ALPHA_NETWORK_COMPILER_PATH, generatedFile.getSourceName());
                    try {
                        Files.deleteIfExists(newFile);
                        Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
                        byte[] bytes = generatedFile.getSource().getBytes(StandardCharsets.UTF_8);
                        Files.write(newFile, bytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                        this.getLog().info((CharSequence)("Written Compiled Alpha Network: " + newFile));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new MojoExecutionException("Unable to write file", (Exception)e);
                    }
                }
            }
            String ancFile = CanonicalKieModule.getANCFile((ReleaseId)new ReleaseIdImpl(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion()));
            Path ancFilePath = Paths.get(this.targetDirectory.getPath(), "classes", ancFile);
            try {
                Files.deleteIfExists(ancFilePath);
                Files.createDirectories(ancFilePath.getParent(), new FileAttribute[0]);
                Files.createFile(ancFilePath, new FileAttribute[0]);
                this.getLog().info((CharSequence)("Written ANC File: " + ancFilePath.toAbsolutePath()));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new MojoExecutionException("Unable to write file: ", (Exception)e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        this.getLog().info((CharSequence)"Compiled Alpha Network successfully generated");
    }
}

