/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.core.io.internal.InternalResource;
import org.kie.api.KieServices;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.dmn.api.core.GeneratedSource;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.assembler.DMNAssemblerService;
import org.kie.dmn.core.compiler.DMNCompilerConfigurationImpl;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceWithConfigurationImpl;
import org.kie.maven.plugin.AbstractKieMojo;
import org.kie.maven.plugin.DMNModelMode;
import org.kie.maven.plugin.ExecModelMode;

@Mojo(name="generateDMNModel", requiresDependencyResolution=ResolutionScope.NONE, requiresProject=true, defaultPhase=LifecyclePhase.COMPILE)
public class GenerateDMNModelMojo
extends AbstractKieMojo {
    @Parameter(required=true, defaultValue="${project.build.directory}")
    private File targetDirectory;
    @Parameter(required=true, defaultValue="${project.basedir}")
    private File projectDir;
    @Parameter
    private Map<String, String> properties;
    @Parameter(required=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="generateDMNModel", defaultValue="no")
    private String generateDMNModel;

    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean DMNmodelParameterEnabled = DMNModelMode.modelParameterEnabled(this.generateDMNModel);
        boolean modelCompilerInClassPath = ExecModelMode.isModelCompilerInClassPath(this.project.getDependencies());
        if (DMNmodelParameterEnabled && modelCompilerInClassPath) {
            this.generateDMNModel();
        }
    }

    private void generateDMNModel() throws MojoExecutionException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        KieServices ks = KieServices.Factory.get();
        try {
            this.setSystemProperties(this.properties);
            KieBuilderImpl kieBuilder = (KieBuilderImpl)ks.newKieBuilder(this.projectDir);
            DMNCompilerConfigurationImpl dmnCompilerConfiguration = (DMNCompilerConfigurationImpl)DMNFactory.newCompilerConfiguration();
            ArrayList<String> compiledClassNames = new ArrayList<String>();
            dmnCompilerConfiguration.setDeferredCompilation(Boolean.valueOf(true));
            dmnCompilerConfiguration.addListener(generatedSource -> {
                String droolsModelCompilerPath = "/generated-sources/dmn/main/java";
                this.addNewCompileRoot("/generated-sources/dmn/main/java");
                for (GeneratedSource generatedFile : generatedSource) {
                    Path fileNameRelative = this.transformPathToMavenPath(generatedFile);
                    compiledClassNames.add(this.getCompiledClassName(fileNameRelative));
                    Path newFile = Paths.get(this.targetDirectory.getPath(), "/generated-sources/dmn/main/java", fileNameRelative.toString());
                    this.createInvokerSourceFile(newFile, generatedFile.getSourceContent());
                }
            });
            InternalKieModule kieModule = (InternalKieModule)kieBuilder.getKieModuleIgnoringErrors();
            List<String> dmnFiles = this.getDMNFIles(kieModule);
            this.getLog().info((CharSequence)("dmnFiles to process: " + dmnFiles));
            DMNAssemblerService assemblerService = new DMNAssemblerService(dmnCompilerConfiguration);
            KnowledgeBuilder knowledgeBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            for (String dmnFile : dmnFiles) {
                this.compileDMNFile(kieModule, assemblerService, knowledgeBuilder, dmnFile);
            }
            this.createDMNFile(compiledClassNames);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        this.getLog().info((CharSequence)"DMN Model successfully generated");
    }

    private void createDMNFile(List<String> compiledClassNames) {
        Path dmnCompiledClassFile = Paths.get(this.targetDirectory.getPath(), "classes", "META-INF/kie/dmn");
        try {
            if (!Files.exists(dmnCompiledClassFile, new LinkOption[0])) {
                Files.createDirectories(dmnCompiledClassFile.getParent(), new FileAttribute[0]);
            }
            Files.write(dmnCompiledClassFile, compiledClassNames, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write file", e);
        }
    }

    private List<String> getDMNFIles(InternalKieModule kieModule) {
        return this.getFilesByType(kieModule, "dmn");
    }

    private void compileDMNFile(InternalKieModule kieModule, DMNAssemblerService assemblerService, KnowledgeBuilder knowledgeBuilder, String dmnFile) throws Exception {
        InternalResource resource = kieModule.getResource(dmnFile);
        ResourceConfiguration resourceConfiguration = kieModule.getResourceConfiguration(dmnFile);
        ResourceWithConfigurationImpl resourceWithConfiguration = new ResourceWithConfigurationImpl((Resource)resource, resourceConfiguration, a -> {}, b -> {});
        assemblerService.addResources((Object)knowledgeBuilder, Collections.singletonList(resourceWithConfiguration), ResourceType.DMN);
    }

    private void createInvokerSourceFile(Path newFile, String sourceContent) {
        try {
            Files.deleteIfExists(newFile);
            Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
            Path newFilePath = Files.createFile(newFile, new FileAttribute[0]);
            Files.write(newFilePath, sourceContent.getBytes(), new OpenOption[0]);
            this.getLog().info((CharSequence)("Generating new DMN file" + newFilePath));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write file", e);
        }
    }

    private String getCompiledClassName(Path fileNameRelative) {
        return fileNameRelative.toString().replace("/", ".").replace(".java", "");
    }

    private Path transformPathToMavenPath(GeneratedSource generatedFile) {
        Path originalFilePath;
        Path fileName = Paths.get(generatedFile.getFileName(), new String[0]);
        Path fileNameRelative = fileName.startsWith(originalFilePath = Paths.get("src/main/java", new String[0])) ? originalFilePath.relativize(fileName) : fileName;
        return fileNameRelative;
    }

    private void addNewCompileRoot(String droolsModelCompilerPath) {
        String newCompileSourceRoot = this.targetDirectory.getPath() + droolsModelCompilerPath;
        this.project.addCompileSourceRoot(newCompileSourceRoot);
    }
}

