/*
 * Decompiled with CFR 0.152.
 */
package org.kie.maven.plugin.executors;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.drools.compiler.compiler.io.memory.MemoryFile;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.CompilationCacheProvider;
import org.drools.compiler.kie.builder.impl.DrlProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.MemoryKieModule;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.kie.api.KieServices;
import org.kie.api.builder.Message;
import org.kie.maven.plugin.DiskResourceStore;
import org.kie.maven.plugin.KieMavenPluginContext;
import org.kie.maven.plugin.ProjectPomModel;
import org.kie.maven.plugin.helpers.DMNValidationHelper;
import org.kie.maven.plugin.helpers.ExecutorHelper;
import org.kie.memorycompiler.resources.ResourceStore;
import org.kie.util.maven.support.PomModel;

public class BuildDrlExecutor {
    private BuildDrlExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildDrl(KieMavenPluginContext kieMavenPluginContext) throws MojoFailureException, MojoExecutionException {
        MavenProject project = kieMavenPluginContext.getProject();
        MavenSession mavenSession = kieMavenPluginContext.getMavenSession();
        File outputDirectory = kieMavenPluginContext.getOutputDirectory();
        Map<String, String> properties = kieMavenPluginContext.getProperties();
        File resourceFolder = kieMavenPluginContext.getResourceFolder();
        List<Resource> resources = kieMavenPluginContext.getResources();
        String validateDMN = kieMavenPluginContext.getValidateDMN();
        Log log = kieMavenPluginContext.getLog();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            HashSet<URL> urls = new HashSet<URL>();
            for (String element : project.getCompileClasspathElements()) {
                urls.add(new File(element).toURI().toURL());
            }
            project.setArtifactFilter((ArtifactFilter)new CumulativeScopeArtifactFilter(Arrays.asList("compile", "runtime")));
            for (Artifact artifact : project.getArtifacts()) {
                File file = artifact.getFile();
                if (file == null) continue;
                urls.add(file.toURI().toURL());
            }
            urls.add(outputDirectory.toURI().toURL());
            URLClassLoader projectClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]), BuildDrlExecutor.class.getClassLoader());
            Thread.currentThread().setContextClassLoader(projectClassLoader);
        }
        catch (MalformedURLException | DependencyResolutionRequiredException e) {
            throw new RuntimeException(e);
        }
        try {
            ExecutorHelper.setSystemProperties(properties, log);
            KieServices ks = KieServices.Factory.get();
            KieBuilderImpl kieBuilder = (KieBuilderImpl)ks.newKieBuilder(project.getBasedir());
            kieBuilder.setPomModel((PomModel)new ProjectPomModel(mavenSession));
            kieBuilder.buildAll(DrlProject.SUPPLIER, s -> s.contains(resourceFolder.getAbsolutePath()) || s.endsWith("pom.xml"));
            InternalKieModule kModule = (InternalKieModule)kieBuilder.getKieModule();
            ResultsImpl messages = (ResultsImpl)kieBuilder.getResults();
            List errors = messages != null ? messages.filterMessages(new Message.Level[]{Message.Level.ERROR}) : Collections.emptyList();
            CompilationCacheProvider.get().writeKieModuleMetaInfo(kModule, (ResourceStore)new DiskResourceStore(outputDirectory));
            if (!errors.isEmpty()) {
                for (Message error : errors) {
                    log.error((CharSequence)error.toString());
                }
                throw new MojoFailureException("Build failed!");
            }
            BuildDrlExecutor.writeClassFiles(kModule, outputDirectory);
            if (DMNValidationHelper.shallPerformDMNDTAnalysis(validateDMN, log)) {
                DMNValidationHelper.performDMNDTAnalysis(kModule, resources, log);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        log.info((CharSequence)"KieModule successfully built!");
    }

    private static void writeClassFiles(InternalKieModule kModule, File outputDirectory) throws MojoFailureException {
        MemoryFileSystem mfs = ((MemoryKieModule)kModule).getMemoryFileSystem();
        kModule.getFileNames().stream().filter(name -> name.endsWith(".class") && !name.contains("target/classes") && !name.contains("target\\classes") && !name.contains("target/test-classes") && !name.contains("target\\test-classes")).forEach(fileName -> {
            try {
                BuildDrlExecutor.saveFile(mfs, fileName, outputDirectory);
            }
            catch (MojoFailureException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static void saveFile(MemoryFileSystem mfs, String fileName, File outputDirectory) throws MojoFailureException {
        MemoryFile memFile = (MemoryFile)mfs.getFile(fileName);
        Path path = Paths.get(outputDirectory.getPath(), memFile.getPath().asString());
        try {
            Files.deleteIfExists(path);
            Files.createDirectories(path, new FileAttribute[0]);
            Files.copy(memFile.getContents(), path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException iox) {
            throw new MojoFailureException("Unable to write file", (Throwable)iox);
        }
    }
}

