/*
 * Decompiled with CFR 0.152.
 */
package org.kie.memorycompiler;

import java.util.Arrays;
import org.kie.memorycompiler.jdknative.NativeJavaCompiler;

public class JavaConfiguration {
    protected static final String[] LANGUAGE_LEVELS = new String[]{"1.5", "1.6", "1.7", "1.8", "10", "11", "12", "13", "14", "15", "9"};
    public static final String JAVA_COMPILER_PROPERTY = "drools.dialect.java.compiler";
    public static final String JAVA_LANG_LEVEL_PROPERTY = "drools.dialect.java.compiler.lnglevel";
    private String languageLevel;
    private CompilerType compiler;

    public static String findJavaVersion(String level) {
        if (level.startsWith("1.5")) {
            return "1.5";
        }
        if (level.startsWith("1.6")) {
            return "1.6";
        }
        if (level.startsWith("1.7")) {
            return "1.7";
        }
        if (level.startsWith("1.8")) {
            return "1.8";
        }
        if (level.startsWith("9")) {
            return "9";
        }
        if (level.startsWith("10")) {
            return "10";
        }
        return "11";
    }

    public String getJavaLanguageLevel() {
        return this.languageLevel;
    }

    public void setJavaLanguageLevel(String languageLevel) {
        if (Arrays.binarySearch(LANGUAGE_LEVELS, languageLevel) < 0) {
            throw new RuntimeException("value '" + languageLevel + "' is not a valid language level");
        }
        this.languageLevel = languageLevel;
    }

    public void setCompiler(CompilerType compiler) {
        switch (compiler) {
            case ECLIPSE: {
                this.compiler = CompilerType.ECLIPSE;
                break;
            }
            case NATIVE: {
                this.compiler = CompilerType.NATIVE;
                break;
            }
            default: {
                throw new RuntimeException("value '" + (Object)((Object)compiler) + "' is not a valid compiler");
            }
        }
    }

    public CompilerType getCompiler() {
        return this.compiler;
    }

    public static enum CompilerType {
        ECLIPSE("org.drools.ecj.EclipseJavaCompiler"),
        NATIVE(NativeJavaCompiler.class);

        private final String implClassName;
        private Class<?> implClass;

        private CompilerType(String className) {
            this.implClassName = className;
        }

        private CompilerType(Class<?> implClass) {
            this.implClassName = implClass.getCanonicalName();
            this.implClass = implClass;
        }

        public Class<?> getImplClass() {
            if (this.implClass == null) {
                try {
                    this.implClass = Class.forName(this.implClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.implClass;
        }

        public String getImplClassName() {
            return this.implClassName;
        }
    }
}

