/*
 * Decompiled with CFR 0.152.
 */
package org.kie.perf;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.kie.perf.SharedMetricRegistry;
import org.kie.perf.TestConfig;
import org.kie.perf.metrics.CsvSingleReporter;
import org.kie.perf.metrics.MemoryUsageGaugeSet;
import org.kie.perf.metrics.ThreadStatesGaugeSet;
import org.kie.perf.scenario.IPerfTest;
import org.kie.perf.suite.ITestSuite;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Executor {
    protected static final Logger log = LoggerFactory.getLogger(Executor.class);
    private ScheduledReporter reporter;

    public ITestSuite findTestSuite() throws Exception {
        Class<?> csuite = Class.forName("org.kie.perf.suite." + TestConfig.getInstance().getSuite());
        return (ITestSuite)csuite.newInstance();
    }

    public void initMetrics(IPerfTest scenario) {
        File reportDataLocation;
        MetricRegistry metrics = SharedMetricRegistry.getInstance();
        TestConfig tc = TestConfig.getInstance();
        TestConfig.ReporterType reporterType = tc.getReporterType();
        if (reporterType == TestConfig.ReporterType.CONSOLE) {
            this.reporter = ConsoleReporter.forRegistry((MetricRegistry)metrics).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        } else if (reporterType == TestConfig.ReporterType.CSV) {
            reportDataLocation = new File(tc.getReportDataLocation());
            if (!reportDataLocation.exists()) {
                reportDataLocation.mkdirs();
            }
            this.reporter = CsvReporter.forRegistry((MetricRegistry)metrics).formatFor(Locale.US).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(reportDataLocation);
            this.reporter.start((long)tc.getPeriodicity(), TimeUnit.SECONDS);
        } else if (reporterType == TestConfig.ReporterType.CSVSINGLE) {
            reportDataLocation = new File(tc.getReportDataLocation());
            if (!reportDataLocation.exists()) {
                reportDataLocation.mkdirs();
            }
            this.reporter = CsvSingleReporter.forRegistry(metrics).formatFor(Locale.US).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(reportDataLocation);
        }
        for (TestConfig.Measure m : tc.getMeasure()) {
            if (m == TestConfig.Measure.MEMORYUSAGE) {
                metrics.registerAll((MetricSet)new MemoryUsageGaugeSet(scenario.getClass()));
                continue;
            }
            if (m == TestConfig.Measure.FILEDESCRIPTORS) {
                metrics.register(MetricRegistry.name(scenario.getClass(), (String[])new String[]{"file.descriptors.usage"}), (Metric)new FileDescriptorRatioGauge());
                metrics.register(MetricRegistry.name(scenario.getClass(), (String[])new String[]{"file.descriptors.used"}), (Metric)new Gauge<Long>(){

                    public Long getValue() {
                        try {
                            OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
                            Method method = os.getClass().getDeclaredMethod("getOpenFileDescriptorCount", new Class[0]);
                            method.setAccessible(true);
                            return (Long)method.invoke((Object)os, new Object[0]);
                        }
                        catch (Exception exception) {
                            return -1L;
                        }
                    }
                });
                continue;
            }
            if (m != TestConfig.Measure.THREADSTATES) continue;
            metrics.registerAll((MetricSet)new ThreadStatesGaugeSet(scenario.getClass()));
        }
    }

    public IPerfTest selectNextTestFromSuite(ITestSuite testSuite) throws Exception {
        TestConfig tc = TestConfig.getInstance();
        String testPackage = testSuite.getTestPackage();
        Class<?> selectedScenario = null;
        if (tc.getScenario() != null) {
            selectedScenario = Class.forName(testPackage + "." + tc.getScenario());
        }
        Reflections reflections = new Reflections(testPackage, new Scanner[0]);
        Set scenarios = reflections.getSubTypesOf(IPerfTest.class);
        IPerfTest instance = null;
        if (selectedScenario == null) {
            for (Class c : scenarios) {
                if (selectedScenario != null) continue;
                ProcessBuilder processBuilder = new ProcessBuilder(tc.getStartScriptLocation(), c.getSimpleName());
                try {
                    Process process = processBuilder.start();
                    InputStreamReader isr = new InputStreamReader(process.getInputStream());
                    BufferedReader br = new BufferedReader(isr);
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        System.out.println(line);
                    }
                    process.waitFor();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            try {
                instance = (IPerfTest)selectedScenario.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    public void report() {
        this.reporter.report();
    }

    public static void main(String[] args) {
        Executor exec = new Executor();
        try {
            TestConfig tc = TestConfig.getInstance();
            ITestSuite testSuite = exec.findTestSuite();
            IPerfTest scenario = exec.selectNextTestFromSuite(testSuite);
            String msg = "======== SUITE: " + tc.getSuite();
            String scenarioName = tc.getScenario();
            if (scenarioName != null) {
                msg = msg + " / SCENARIO: " + scenarioName;
            }
            msg = msg + " ========";
            log.info(msg);
            if (scenario != null) {
                exec.initMetrics(scenario);
                testSuite.initScenario(scenario);
                if (tc.isWarmUp()) {
                    SharedMetricRegistry.setWarmUp(true);
                    scenario.initMetrics();
                    for (int i = 0; i < tc.getWarmUpCount(); ++i) {
                        scenario.execute();
                    }
                    SharedMetricRegistry.setWarmUp(false);
                }
                scenario.initMetrics();
                testSuite.startScenario(scenario);
                exec.report();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }
}

